/*
 * Decompiled with CFR 0.152.
 */
package br.com.jarch.core.model;

import br.com.jarch.core.annotation.JArchColumnDataTable;
import br.com.jarch.core.annotation.JArchColumnDataTableShow;
import br.com.jarch.core.annotation.JArchColumnsDataTable;
import br.com.jarch.core.annotation.JArchListController;
import br.com.jarch.core.crud.dynamic.FieldDynamicEntity;
import br.com.jarch.core.crud.dynamic.FieldDynamicJpqlBuilder;
import br.com.jarch.core.crud.dynamic.IDynamicColumn;
import br.com.jarch.core.jpa.type.FieldOrder;
import br.com.jarch.core.model.ColumnList;
import br.com.jarch.core.model.IColumnList;
import br.com.jarch.core.model.IIdentity;
import br.com.jarch.core.type.AlignType;
import br.com.jarch.core.util.BundleUtils;
import br.com.jarch.util.LogUtils;
import br.com.jarch.util.ReflectionUtils;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public final class ColumnsList
extends ArrayList<IColumnList> {
    private ColumnsList() {
    }

    public static ColumnsList create(Class<?> clazzEntity) {
        return ColumnsList.create(clazzEntity, null, null);
    }

    public static ColumnsList create(Class<?> clazzEntity, Class<?> clazzAction) {
        return ColumnsList.create(clazzEntity, clazzAction, null);
    }

    public static ColumnsList create(Class<?> clazzEntity, Class<?> clazzController, Class<?> clazzEntityMaster) {
        boolean onlyColumnsController = false;
        JArchListController listControllerAnnotation = null;
        if (clazzController != null) {
            listControllerAnnotation = clazzController.getAnnotation(JArchListController.class);
            if (listControllerAnnotation == null) {
                listControllerAnnotation = clazzController.getSuperclass().getAnnotation(JArchListController.class);
            }
            onlyColumnsController = listControllerAnnotation != null && listControllerAnnotation.onlyColumnDataTableThisClassOrPackageInfo();
        }
        ColumnsList columnsList = new ColumnsList();
        if (onlyColumnsController) {
            columnsList.addAll(ColumnsList.createColumnsFromClassEntity(clazzEntity));
            columnsList.addAll(ColumnsList.createColumnsFromPackage(clazzController.getPackage(), clazzEntity));
            columnsList.addAll(ColumnsList.createColumnFromDynamic(clazzEntity));
        } else {
            columnsList.addAll(ColumnsList.createColumnsFromClassEntity(clazzEntity));
            columnsList.addAll(ColumnsList.createColumnsFromFieldsEntity(clazzEntity));
            if (clazzEntityMaster != null && !clazzEntityMaster.getPackage().equals(clazzEntity.getPackage())) {
                columnsList.addAll(ColumnsList.createColumnsFromPackage(clazzEntityMaster.getPackage(), clazzEntity));
            }
            columnsList.addAll(ColumnsList.createColumnsFromPackage(clazzEntity.getPackage(), clazzEntity));
            if (clazzController != null && !clazzController.getPackage().equals(clazzEntity.getPackage())) {
                columnsList.addAll(ColumnsList.createColumnsFromPackage(clazzController.getPackage(), clazzEntity));
            }
            columnsList.addAll(ColumnsList.createColumnFromDynamic(clazzEntity));
            if (clazzController != null) {
                columnsList.addAll(ColumnsList.createColumnsFromAction(clazzEntity, clazzController));
                ColumnsList.removeColumnsNotColumnDataTableShow(clazzController, columnsList);
                ColumnsList.removeColumnsNotColumnListActionConfiguration(listControllerAnnotation, columnsList);
            }
        }
        return columnsList;
    }

    private static List<IColumnList> createColumnsFromAction(Class<?> classEntity, Class<?> classAction) {
        ColumnsList listaColunaLista = new ColumnsList();
        JArchColumnDataTable[] archColumnDataTables = (JArchColumnDataTable[])classAction.getAnnotationsByType(JArchColumnDataTable.class);
        ColumnsList.addColumnDataTable(classEntity, listaColunaLista, archColumnDataTables);
        return listaColunaLista;
    }

    private static ColumnsList createColumnsFromClassEntity(Class<?> clazzEntity) {
        ColumnsList result = new ColumnsList();
        ColumnsList.addColumnDataTable(clazzEntity, result, (JArchColumnDataTable[])clazzEntity.getAnnotationsByType(JArchColumnDataTable.class));
        return result;
    }

    private static ColumnsList createColumnsFromPackage(Package packageSource, Class<?> classTarget) {
        ColumnsList result = new ColumnsList();
        ColumnsList.addColumnDataTable(classTarget, result, (JArchColumnDataTable[])packageSource.getAnnotationsByType(JArchColumnDataTable.class));
        Arrays.stream((JArchColumnsDataTable[])packageSource.getAnnotationsByType(JArchColumnsDataTable.class)).filter(c -> c.classEntity().equals(classTarget)).forEach((? super T c) -> ColumnsList.addColumnDataTable(classTarget, result, c.columns()));
        return result;
    }

    private static ColumnsList createColumnsFromFieldsEntity(Class<?> clazzEntity) {
        ColumnsList result = new ColumnsList();
        for (Field field : clazzEntity.getDeclaredFields()) {
            if (field.getClass().isInstance(IIdentity.class) || field.getName().equals("versao")) continue;
            ColumnsList.addColumnDataTable(clazzEntity, result, (JArchColumnDataTable[])field.getAnnotationsByType(JArchColumnDataTable.class), field.getName());
        }
        return result;
    }

    private static ColumnsList createColumnFromDynamic(Class<?> classEntity) {
        ColumnsList result = new ColumnsList();
        if (IDynamicColumn.class.isAssignableFrom(classEntity)) {
            List listFieldsDynamic = FieldDynamicJpqlBuilder.newInstance().orderBy(FieldOrder.asc("row"), FieldOrder.asc("column")).where().equalsTo("nameEntity", (Object)classEntity.getSimpleName()).and().equalsTo("datatable", (Object)true).collect().list();
            for (FieldDynamicEntity fieldDynamic : listFieldsDynamic) {
                ColumnsList.addColumnDataTable(classEntity, result, fieldDynamic);
            }
        }
        return result;
    }

    private static void addColumnDataTable(Class<?> clazzEntity, ColumnsList columnsList, JArchColumnDataTable[] columnDataTables) {
        ColumnsList.addColumnDataTable(clazzEntity, columnsList, columnDataTables, null);
    }

    private static void addColumnDataTable(Class<?> clazzEntity, ColumnsList columnsList, JArchColumnDataTable[] columnDataTables, String pFieldName) {
        for (JArchColumnDataTable columnDataTable : columnDataTables) {
            if (columnDataTable.classEntity() != Void.TYPE && columnDataTable.classEntity() != clazzEntity) continue;
            try {
                if (Boolean.FALSE.equals(columnDataTable.enable().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]).get())) {
                    continue;
                }
            }
            catch (Exception ex) {
                LogUtils.generateSilent((Throwable)ex);
            }
            String fieldName = columnDataTable.field();
            try {
                Field field = null;
                try {
                    field = ReflectionUtils.getField(clazzEntity, (String)(pFieldName == null || pFieldName.isEmpty() ? fieldName : pFieldName), (boolean)true);
                }
                catch (Exception ex) {
                    LogUtils.generateSilent((Throwable)ex);
                }
                IColumnList colunaLista = ColumnsList.configDataTable(field, columnDataTable);
                colunaLista.subQuery(columnDataTable.subQuery());
                columnsList.add(colunaLista);
            }
            catch (Exception ex) {
                LogUtils.warning((String)("JARCH ERROR: Problema na identifica\u00e7\u00e3o da coluna " + fieldName + " da classe " + clazzEntity.getSimpleName()));
            }
        }
    }

    private static void addColumnDataTable(Class<?> clazzEntity, ColumnsList columnsList, FieldDynamicEntity fieldDynamic) {
        try {
            IColumnList colunaLista = ColumnsList.configDataTable(fieldDynamic);
            columnsList.add(colunaLista);
        }
        catch (Exception ex) {
            LogUtils.warning((String)("JARCH ERROR: Problema na identifica\u00e7\u00e3o da coluna " + fieldDynamic.getColumn() + " da classe " + clazzEntity.getSimpleName()));
        }
    }

    private static IColumnList configDataTable(Field field, JArchColumnDataTable columnDataTable) {
        String fieldName = columnDataTable.field();
        IColumnList columnList = new ColumnList(BundleUtils.messageBundle(columnDataTable.title()), fieldName.isEmpty() ? field.getName() : fieldName, columnDataTable.type()).position(columnDataTable.position()).width(columnDataTable.width());
        columnList = columnDataTable.order() ? columnList.order() : columnList.noOrder();
        columnList = columnDataTable.visible() ? columnList.visible() : columnList.hide();
        columnList = columnList.totalize(columnDataTable.totalize());
        Object styleAlign = columnDataTable.align() == AlignType.NONE ? columnDataTable.type().getStyleAlignText() : "text-align: " + columnDataTable.align().name().toLowerCase();
        Object styleWidth = columnDataTable.width() == 0 ? columnDataTable.type().getStyleWidth() : "width: " + columnDataTable.width() + "px";
        columnList.style((String)styleAlign + "; " + (String)styleWidth);
        return columnList;
    }

    private static IColumnList configDataTable(FieldDynamicEntity fieldDynamic) {
        String fieldName = "dynamicColumn." + fieldDynamic.getColumnName();
        IColumnList columnList = new ColumnList(fieldDynamic.getLabel(), fieldName, fieldDynamic.getField()).position(fieldDynamic.getColumnDatatable()).width(fieldDynamic.getType().getWidthXhtml());
        columnList = columnList.noOrder();
        columnList = columnList.visible();
        columnList = columnList.totalize(true);
        String styleAlign = fieldDynamic.getField().getStyleAlignText();
        String styleWidth = fieldDynamic.getField().getStyleWidth();
        columnList = columnList.style(styleAlign.concat(";").concat(styleWidth));
        return columnList;
    }

    private static void removeColumnsNotColumnDataTableShow(Class<?> clazzAction, ColumnsList listReturn) {
        JArchColumnDataTableShow columnDataTableShow = clazzAction.getAnnotation(JArchColumnDataTableShow.class);
        if (columnDataTableShow != null) {
            listReturn.removeIf(c -> Arrays.stream(columnDataTableShow.fieldOrId()).noneMatch(a -> a.equals(c.getField())));
        }
    }

    private static void removeColumnsNotColumnListActionConfiguration(JArchListController listControllerAnnotation, ColumnsList listaColunaLista) {
        if (listControllerAnnotation == null || listControllerAnnotation.fieldShowDataTable().length == 0) {
            return;
        }
        listaColunaLista.removeIf(c -> Arrays.stream(listControllerAnnotation.fieldShowDataTable()).noneMatch(a -> c.getField().equals(a)));
    }
}

