/*
 * Decompiled with CFR 0.152.
 */
package br.com.jarch.core.jpa.converter;

import br.com.jarch.util.DateUtils;
import jakarta.persistence.AttributeConverter;
import jakarta.persistence.Converter;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Date;

@Converter
public class LocalDateTimeJpaConverter
implements AttributeConverter<LocalDateTime, Date> {
    public Date convertToDatabaseColumn(LocalDateTime localDateTime) {
        if (localDateTime == null) {
            return null;
        }
        return DateUtils.toDate((LocalDateTime)localDateTime.atZone(ZoneId.systemDefault()).toLocalDateTime());
    }

    public LocalDateTime convertToEntityAttribute(Date date) {
        if (date == null) {
            return null;
        }
        Instant instant = Instant.ofEpochMilli(date.getTime());
        return LocalDateTime.ofInstant(instant, ZoneId.systemDefault());
    }
}

