/*
 * Decompiled with CFR 0.152.
 */
package br.com.jarch.core.jpa.api;

import br.com.jarch.core.jpa.api.AliasJpql;
import br.com.jarch.core.jpa.api.AttributeJpql;
import br.com.jarch.core.jpa.api.CollectorJpql;
import br.com.jarch.core.jpa.api.HavingJpql;
import br.com.jarch.core.jpa.api.IAggregateJpql;
import br.com.jarch.core.jpa.api.JoinFetch;
import br.com.jarch.core.jpa.api.WhereJpql;
import br.com.jarch.core.jpa.param.ParamFieldValue;
import br.com.jarch.core.jpa.param.ParamFieldValues;
import br.com.jarch.core.jpa.type.FieldOrder;
import br.com.jarch.core.model.IIdentity;
import br.com.jarch.core.type.EntityGraphType;
import br.com.jarch.core.util.EntityManagerFilterUtils;
import br.com.jarch.core.util.JpqlUtils;
import jakarta.persistence.EntityManager;
import jakarta.persistence.LockModeType;
import jakarta.persistence.Query;
import jakarta.persistence.metamodel.Attribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

public final class RootJpql<E extends IIdentity> {
    private final EntityManager entityManager;
    ParamFieldValues wheres;
    ParamFieldValues havings;
    List<String> groupBys;
    List<String> selects;
    List<FieldOrder> orderBys;
    Collection<JoinFetch<?>> joinFetchs;
    boolean cacheable;
    boolean distinct;
    int firstResult;
    int maxResults;
    String entityGraph;
    EntityGraphType graphType;
    Class<E> classEntity;
    LockModeType lockMode;

    public RootJpql(Class<E> classEntity, EntityManager entityManager) {
        this.classEntity = classEntity;
        this.entityManager = entityManager;
        this.wheres = new ParamFieldValues(classEntity);
        this.orderBys = new ArrayList<FieldOrder>();
        this.groupBys = new ArrayList<String>();
        this.selects = new ArrayList<String>();
        this.havings = new ParamFieldValues(classEntity, false);
        this.joinFetchs = new ArrayList();
    }

    public RootJpql<E> lockMode(LockModeType lockMode) {
        this.lockMode = lockMode;
        return this;
    }

    public RootJpql<E> cacheable() {
        this.cacheable = true;
        return this;
    }

    public RootJpql<E> noCacheable() {
        this.cacheable = false;
        return this;
    }

    public RootJpql<E> distinct() {
        this.distinct = true;
        return this;
    }

    public RootJpql<E> setFirstResults(int firstResults) {
        this.firstResult = firstResults;
        return this;
    }

    public RootJpql<E> setMaxResults(int maxResults) {
        this.maxResults = maxResults;
        return this;
    }

    public RootJpql<E> select(String field) {
        this.selects.add(field);
        return this;
    }

    public RootJpql<E> select(String ... fields) {
        for (String field : fields) {
            this.selects.add(field);
        }
        return this;
    }

    public RootJpql<E> select(AttributeJpql<?> ... fields) {
        for (AttributeJpql<?> field : fields) {
            this.selects.add(field.getAttribute());
        }
        return this;
    }

    public RootJpql<E> select(Class<?> classEntity) {
        return this.select(JpqlUtils.aliasEntity(classEntity));
    }

    public RootJpql<E> select(Attribute<? super E, ?> attribute) {
        this.selects.add(attribute.getName());
        return this;
    }

    @SafeVarargs
    public final RootJpql<E> select(Attribute<? super E, ?> ... attributes) {
        for (Attribute<? super E, ?> attribute : attributes) {
            this.selects.add(attribute.getName());
        }
        return this;
    }

    public RootJpql<E> select(IAggregateJpql aggregate) {
        this.selects.add(aggregate.getCommand());
        return this;
    }

    public RootJpql<E> select(IAggregateJpql ... aggregates) {
        for (IAggregateJpql aggregate : aggregates) {
            this.selects.add(aggregate.getCommand());
        }
        return this;
    }

    public RootJpql<E> groupBy(Attribute<? super E, ?> ... attributes) {
        for (Attribute<? super E, ?> attribute : attributes) {
            this.groupBys.add(attribute.getName());
        }
        return this;
    }

    public RootJpql<E> groupBy(String ... attributes) {
        Collections.addAll(this.groupBys, attributes);
        return this;
    }

    public RootJpql<E> orderBy(FieldOrder ... fieldOrders) {
        Collections.addAll(this.orderBys, fieldOrders);
        return this;
    }

    public RootJpql<E> orderByAsc(String field) {
        this.orderBys.add(FieldOrder.asc(field));
        return this;
    }

    public RootJpql<E> orderByDesc(String field) {
        this.orderBys.add(FieldOrder.desc(field));
        return this;
    }

    public RootJpql<E> orderByAsc(IAggregateJpql aggregate) {
        this.orderBys.add(FieldOrder.asc(aggregate));
        return this;
    }

    public RootJpql<E> orderByDesc(IAggregateJpql aggregate) {
        this.orderBys.add(FieldOrder.desc(aggregate));
        return this;
    }

    public RootJpql<E> orderByAsc(Class<?> classEntity) {
        this.orderByAsc(JpqlUtils.aliasEntity(classEntity));
        return this;
    }

    public RootJpql<E> orderByDesc(Class<?> classEntity) {
        this.orderByDesc(JpqlUtils.aliasEntity(classEntity));
        return this;
    }

    public RootJpql<E> orderByAsc(Attribute<? super E, ?> attribute) {
        this.orderByAsc(attribute.getName());
        return this;
    }

    public RootJpql<E> orderByDesc(Attribute<? super E, ?> attribute) {
        this.orderByDesc(attribute.getName());
        return this;
    }

    public RootJpql<E> entityGraph(String entityGraph) {
        this.entityGraph = entityGraph;
        return this;
    }

    public RootJpql<E> entityGraph(String entityGraph, EntityGraphType graphType) {
        this.entityGraph = entityGraph;
        this.graphType = graphType;
        return this;
    }

    public RootJpql<E> fetchJoin(Attribute<? super E, ?> field, AliasJpql alias) {
        this.joinFetchs.add(JoinFetch.join(field, alias));
        return this;
    }

    public RootJpql<E> fetchJoin(AliasJpql fromAlias, Attribute<?, ?> field) {
        this.joinFetchs.add(JoinFetch.join(fromAlias, field));
        return this;
    }

    public RootJpql<E> fetchJoin(AliasJpql fromAlias, Attribute<?, ?> field, AliasJpql newAlias) {
        this.joinFetchs.add(JoinFetch.join(fromAlias, field, newAlias));
        return this;
    }

    public RootJpql<E> fetchJoin(Attribute<? super E, ?> attribute) {
        this.joinFetchs.add(JoinFetch.join(attribute));
        return this;
    }

    public RootJpql<E> fetchJoin(String attribute) {
        this.joinFetchs.add(JoinFetch.join(attribute));
        return this;
    }

    public RootJpql<E> fetchLeftJoin(Attribute<? super E, ?> field, AliasJpql alias) {
        this.joinFetchs.add(JoinFetch.left(field, alias));
        return this;
    }

    public RootJpql<E> fetchLeftJoin(AliasJpql fromAlias, Attribute<?, ?> field) {
        this.joinFetchs.add(JoinFetch.left(fromAlias, field));
        return this;
    }

    public RootJpql<E> fetchLeftJoin(AliasJpql fromAlias, Attribute<?, ?> field, AliasJpql newAlias) {
        this.joinFetchs.add(JoinFetch.left(fromAlias, field, newAlias));
        return this;
    }

    public RootJpql<E> fetchLeftJoin(Attribute<? super E, ?> attribute) {
        this.joinFetchs.add(JoinFetch.left(attribute));
        return this;
    }

    public Object[] aggregate(String[] aggregateFields, ParamFieldValues paramFieldValues) {
        Object comandoJpa = "SELECT ";
        comandoJpa = (String)comandoJpa + Arrays.stream(aggregateFields).collect(Collectors.joining(", "));
        comandoJpa = (String)comandoJpa + JpqlUtils.from(this.classEntity) + " ";
        comandoJpa = (String)comandoJpa + JpqlUtils.where(this.classEntity, paramFieldValues, this.joinFetchs);
        Query query = this.getEntityManager().createQuery((String)comandoJpa);
        JpqlUtils.addValueParam(query, paramFieldValues);
        return (Object[])query.getSingleResult();
    }

    public WhereJpql<E> where() {
        return new WhereJpql(this, ParamFieldValue.OperatorType.AND);
    }

    public HavingJpql<E> having() {
        return new HavingJpql(this, ParamFieldValue.OperatorType.AND);
    }

    public CollectorJpql<E> collect() {
        return new CollectorJpql(this);
    }

    EntityManager getEntityManager() {
        EntityManagerFilterUtils.addFilters(this.entityManager);
        return this.entityManager;
    }
}

