/*
 * Decompiled with CFR 0.152.
 */
package br.com.jarch.core.excel;

import br.com.jarch.core.excel.BandLocationType;
import br.com.jarch.core.excel.Excel;
import br.com.jarch.core.excel.JArchColumnExcel;
import br.com.jarch.core.excel.JArchHeaderExcel;
import br.com.jarch.core.type.ExcelType;
import br.com.jarch.core.util.BundleUtils;
import br.com.jarch.util.ByteUtils;
import br.com.jarch.util.ReflectionUtils;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.invoke.CallSite;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.poi.hssf.usermodel.HSSFDateUtil;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class ExcelUtils {
    public static Collection<Map<String, Object>> readExcel(File file) throws IOException {
        if (file.getName().endsWith("xls")) {
            return ExcelUtils.readXls(ByteUtils.toByteArray((File)file));
        }
        if (file.getName().endsWith("xlsx")) {
            return ExcelUtils.readXlsx(ByteUtils.toByteArray((File)file));
        }
        throw new FileNotFoundException("Type file NOT XLS or XLSX");
    }

    public static Collection<Map<String, Object>> readXls(byte[] excel) throws IOException {
        return ExcelUtils.readExcel(ExcelType.XLS, excel);
    }

    public static Collection<Map<String, Object>> readXlsx(byte[] excel) throws IOException {
        return ExcelUtils.readExcel(ExcelType.XLSX, excel);
    }

    private static Collection<Map<String, Object>> readExcel(ExcelType tipoExcel, byte[] bytes) throws IOException {
        ByteArrayInputStream inputStream = new ByteArrayInputStream(bytes);
        Object workbook = ExcelType.XLSX.equals((Object)tipoExcel) ? new XSSFWorkbook((InputStream)inputStream) : new HSSFWorkbook((InputStream)inputStream);
        Sheet worksheet = workbook.getSheetAt(0);
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        for (int i = 0; i <= worksheet.getLastRowNum(); ++i) {
            Row row = worksheet.getRow(i);
            HashMap<CallSite, Object> mapRow = new HashMap<CallSite, Object>();
            if (row == null || ExcelUtils.isAllColumnsNullOrEmpty(row)) {
                mapRow.put((CallSite)((Object)("" + i)), null);
                continue;
            }
            for (int j = 0; j < row.getLastCellNum(); ++j) {
                Cell cell = row.getCell(j);
                if (cell == null) {
                    mapRow.put((CallSite)((Object)("" + j)), null);
                    continue;
                }
                if (cell.getCellType() == 1) {
                    mapRow.put((CallSite)((Object)("" + j)), cell.getStringCellValue());
                    continue;
                }
                if (cell.getCellType() == 3) {
                    mapRow.put((CallSite)((Object)("" + j)), null);
                    continue;
                }
                if (cell.getCellType() == 2) {
                    mapRow.put((CallSite)((Object)("" + j)), cell.getCellFormula());
                    continue;
                }
                if (cell.getCellType() == 4) {
                    mapRow.put((CallSite)((Object)("" + j)), cell.getBooleanCellValue());
                    continue;
                }
                if (cell.getCellType() != 0) continue;
                if (HSSFDateUtil.isCellDateFormatted((Cell)cell)) {
                    mapRow.put((CallSite)((Object)("" + j)), cell.getDateCellValue());
                    continue;
                }
                mapRow.put((CallSite)((Object)("" + j)), cell.getNumericCellValue());
            }
            list.add(mapRow);
        }
        return list;
    }

    private static boolean isAllColumnsNullOrEmpty(Row row) {
        for (int i = 0; i < row.getLastCellNum(); ++i) {
            if (row.getCell(i) == null || row.getCell(i).getStringCellValue().isEmpty()) continue;
            return false;
        }
        return true;
    }

    public static void generate(String namePlain, String title, Collection<?> listData, OutputStream outputStream) throws IOException {
        ExcelUtils.generate(namePlain, title, null, listData, outputStream);
    }

    public static void generate(String namePlain, String title, Object parameterHeader, Collection<?> listData, OutputStream outputStream) throws IOException {
        if (listData.isEmpty()) {
            return;
        }
        Excel excel = Excel.builder().createSheet(namePlain);
        if (title != null && !title.isBlank()) {
            excel.addValueCell(title).addLine();
        }
        if (parameterHeader != null) {
            ExcelUtils.createLineHeader(excel, parameterHeader);
        }
        ExcelUtils.createLineColumnHeader(excel, listData);
        ExcelUtils.createLineColumnDetail(excel, listData);
        excel.build(outputStream);
    }

    public static void createLineHeader(Excel excel, Object parameterHeader) {
        List collectionHeader = (List)ExcelUtils.dataHeader(BandLocationType.HEADER, parameterHeader);
        List collectionData = (List)ExcelUtils.dataHeader(BandLocationType.DATA, parameterHeader);
        int line = 0;
        for (int i = 0; i < collectionHeader.size(); ++i) {
            JArchHeaderExcel column = (JArchHeaderExcel)collectionHeader.get(i);
            Field field = (Field)collectionData.get(i);
            if (line != column.line()) {
                excel = excel.addLine();
                line = column.line();
            }
            if (column.title() != null && !column.title().isEmpty()) {
                String title = BundleUtils.exists(column.title()) ? BundleUtils.messageBundle(column.title()) : column.title();
                excel = excel.addValueCell(title);
            }
            Object conteudo = ReflectionUtils.getValueByField((Object)parameterHeader, (Field)field);
            excel = excel.addValueCell(conteudo);
        }
        excel.addLine();
    }

    private static void createLineColumnHeader(Excel excel, Collection<?> listData) {
        Object data = listData.stream().findAny().orElse(null);
        if (data == null) {
            return;
        }
        Collection<?> collection = ExcelUtils.dataCollection(BandLocationType.HEADER, data);
        ExcelUtils.configHeader(excel, collection);
    }

    public static void configHeader(Excel excel, Collection<?> collection) {
        for (Object column : collection) {
            if (Map.Entry.class.isAssignableFrom(column.getClass())) {
                excel = excel.addValueCell(((Map.Entry)column).getKey());
                continue;
            }
            String title = ((JArchColumnExcel)column).title();
            title = BundleUtils.exists(title) ? BundleUtils.messageBundle(title) : title;
            excel = excel.addValueCell(title);
        }
    }

    private static void createLineColumnDetail(Excel excel, Collection<?> listData) {
        for (Object line : listData) {
            excel = excel.addLine();
            Collection<?> collection = ExcelUtils.dataCollection(BandLocationType.DATA, line);
            excel = ExcelUtils.addValueColumn(excel, line, collection);
        }
    }

    public static Excel addValueColumn(Excel excel, Object line, Collection<?> collection) {
        for (Object column : collection) {
            if (Map.Entry.class.isAssignableFrom(column.getClass())) {
                excel = excel.addValueCell(((Map.Entry)column).getValue());
                continue;
            }
            Object conteudo = ReflectionUtils.getValueByField((Object)line, (Field)((Field)column));
            excel = excel.addValueCell(conteudo);
        }
        return excel;
    }

    public static Collection<?> dataHeader(BandLocationType bandLocation, Object data) {
        Stream<Object> stream = ExcelUtils.getAllFields(data.getClass()).stream().filter(field -> field.isAnnotationPresent(JArchHeaderExcel.class));
        stream = bandLocation == BandLocationType.HEADER ? stream.map(field -> ((Field)field).getAnnotation(JArchHeaderExcel.class)).sorted(Comparator.comparingInt(JArchHeaderExcel::line).thenComparingInt(JArchHeaderExcel::column)) : stream.sorted((field1, field2) -> {
            JArchHeaderExcel column1 = ((Field)field1).getAnnotation(JArchHeaderExcel.class);
            JArchHeaderExcel column2 = ((Field)field2).getAnnotation(JArchHeaderExcel.class);
            int compare = Integer.compare(column1.line(), column2.line());
            if (compare == 0) {
                compare = Integer.compare(column1.column(), column2.column());
            }
            return compare;
        });
        return stream.collect(Collectors.toList());
    }

    private static Collection<?> dataCollection(BandLocationType bandLocation, Object data) {
        Collection<Object> collection = Map.class.isAssignableFrom(data.getClass()) ? new ArrayList(((Map)data).entrySet()) : ExcelUtils.getObjects(bandLocation, data);
        return collection;
    }

    public static Collection<?> getObjects(BandLocationType bandLocation, Object data) {
        Stream<Object> stream = ExcelUtils.getAllFields(data.getClass()).stream().filter(field -> field.isAnnotationPresent(JArchColumnExcel.class));
        stream = bandLocation == BandLocationType.HEADER ? stream.map(field -> ((Field)field).getAnnotation(JArchColumnExcel.class)).sorted(Comparator.comparingInt(JArchColumnExcel::order)) : stream.sorted((field1, field2) -> {
            JArchColumnExcel column1 = ((Field)field1).getAnnotation(JArchColumnExcel.class);
            JArchColumnExcel column2 = ((Field)field2).getAnnotation(JArchColumnExcel.class);
            return Integer.compare(column1.order(), column2.order());
        });
        Collection collection = stream.collect(Collectors.toList());
        return collection;
    }

    private static List<Field> getAllFields(Class<?> aClass) {
        ArrayList<Field> lista = new ArrayList<Field>();
        lista.addAll(Arrays.asList(aClass.getDeclaredFields()));
        if (aClass.getSuperclass() != null) {
            lista.addAll(ExcelUtils.getAllFields(aClass.getSuperclass()));
        }
        return lista;
    }
}

