/*
 * Decompiled with CFR 0.152.
 */
package br.com.jarch.core.crud.service;

import br.com.jarch.core.annotation.JArchLookup;
import br.com.jarch.core.crud.entity.BaseEntity;
import br.com.jarch.core.crud.repository.BaseRepository;
import br.com.jarch.core.crud.search.FieldSearch;
import br.com.jarch.core.crud.search.ISearch;
import br.com.jarch.core.crud.service.IBaseService;
import br.com.jarch.core.model.IIdentity;
import br.com.jarch.core.model.MultiTenant;
import br.com.jarch.core.model.UserInformation;
import br.com.jarch.core.type.ConditionSearchType;
import br.com.jarch.core.type.FieldType;
import br.com.jarch.core.type.LoadCrudType;
import br.com.jarch.util.CharacterUtils;
import br.com.jarch.util.LogUtils;
import br.com.jarch.util.ReflectionUtils;
import jakarta.inject.Inject;
import java.util.Collection;

public abstract class BaseService<E extends IIdentity, R extends BaseRepository<E>>
implements IBaseService<E> {
    @Inject
    private R repository;
    private String idDynamic;

    @Inject
    protected R getRepository() {
        return this.repository;
    }

    @Override
    public Class<E> getClassEntity() {
        return ReflectionUtils.getGenericClass(this.getClass(), (int)0);
    }

    protected MultiTenant getMultiTenant() {
        return MultiTenant.getInstance();
    }

    protected UserInformation getUserInformation() {
        return UserInformation.getInstance();
    }

    @Override
    public String getIdDynamic() {
        return this.idDynamic;
    }

    @Override
    public void setIdDynamic(String idDynamic) {
        this.idDynamic = idDynamic;
        this.getRepository().setIdDynamic(idDynamic);
    }

    @Override
    public E searchCodeLookup(ISearch<E> search, String fieldCode, Object value) {
        if (value == null) {
            return null;
        }
        if (fieldCode == null) {
            JArchLookup lookup = this.getClassEntity().getAnnotation(JArchLookup.class);
            if (lookup == null) {
                LogUtils.warning((String)("Classe " + this.getClass().getSimpleName() + " NAO POSSUI ANOTACAO @JArchLookup SENDO IMPOSSIVEL EXECUTAR A PESQUISA"));
                return null;
            }
            fieldCode = lookup.codeAttribute();
        }
        FieldType fieldType = ReflectionUtils.getField(this.getClassEntity(), (String)fieldCode).getType() == String.class ? FieldType.CODE : FieldType.NUMBER;
        FieldSearch fieldSearchCode = search.getFieldSearch(fieldCode).orElse(null);
        ConditionSearchType condition = null;
        if (fieldSearchCode == null) {
            search.newSearchField(fieldType, fieldCode, ReflectionUtils.createInstance(ReflectionUtils.getField(this.getClassEntity(), (String)fieldCode).getType(), (Object[])new Object[]{value}));
            if (FieldType.CODE.equals((Object)fieldType)) {
                search.getFieldSearch(fieldCode).ifPresent(s -> s.setCondition(ConditionSearchType.CONTAINS));
            } else {
                search.getFieldSearch(fieldCode).ifPresent(s -> s.setCondition(ConditionSearchType.EQUAL));
            }
        } else if (fieldSearchCode.isHasMask() || fieldSearchCode.isZeroLeft()) {
            fieldSearchCode.setValue(value);
            condition = fieldSearchCode.getCondition();
            fieldSearchCode.setCondition(ConditionSearchType.CONTAINS);
        } else {
            fieldSearchCode.setValue(value);
            condition = fieldSearchCode.getCondition();
            fieldSearchCode.setCondition(ConditionSearchType.EQUAL);
        }
        Collection resultList = this.getRepository().searchAllBy(search);
        IIdentity result = resultList.stream().findAny().orElse(null);
        String codeOnlyNumber = CharacterUtils.onlyNumber((String)value.toString());
        if (result == null && !codeOnlyNumber.isBlank()) {
            if (fieldSearchCode == null) {
                search.newSearchField(fieldType, fieldCode, ReflectionUtils.createInstance(ReflectionUtils.getField(this.getClassEntity(), (String)fieldCode).getType(), (Object[])new Object[]{codeOnlyNumber}));
            } else {
                fieldSearchCode.setValue(codeOnlyNumber);
            }
            resultList = this.getRepository().searchAllBy(search);
            result = resultList.stream().findAny().orElse(null);
        }
        if (fieldSearchCode == null) {
            search.removeFilter(fieldCode);
        } else {
            fieldSearchCode.setCondition(condition);
            fieldSearchCode.setValue(null);
        }
        if (result == null) {
            return null;
        }
        return (E)(BaseEntity.class.isAssignableFrom(result.getClass()) ? result : this.getRepository().find(result.getId()));
    }

    @Override
    public void clearAllCache() {
        this.getRepository().clearAllCache();
    }

    @Override
    public void clearCache() {
        this.getRepository().clearCache();
    }

    @Override
    public E loadCrud(Long id) {
        return this.loadCrud(id, null);
    }

    @Override
    public E loadCrud(Long id, String logicFrom) {
        return this.getRepository().loadCrud(id, logicFrom, LoadCrudType.ANY);
    }

    @Override
    public E loadCrud(Long id, String logicFrom, LoadCrudType type) {
        return this.getRepository().loadCrud(id, logicFrom, type);
    }

    @Override
    public E loadCrudAndDetach(Long id) {
        return this.loadCrudAndDetach(id, null);
    }

    @Override
    public E loadCrudAndDetach(Long id, String logicFrom) {
        return this.getRepository().loadCrudAndDetach(id, logicFrom, LoadCrudType.ANY);
    }

    @Override
    public E loadCrudAndDetach(Long id, String logicFrom, LoadCrudType type) {
        return this.getRepository().loadCrudAndDetach(id, logicFrom, type);
    }
}

