/*
 * Decompiled with CFR 0.152.
 */
package br.com.jarch.core.crud.jparepository;

import br.com.jarch.core.annotation.JArchEntityGraphLoadCrud;
import br.com.jarch.core.annotation.JArchEntityGraphSearchList;
import br.com.jarch.core.annotation.JArchEventLoadCrud;
import br.com.jarch.core.annotation.JArchEventReadEntityManager;
import br.com.jarch.core.annotation.JArchEventSearchAfter;
import br.com.jarch.core.annotation.JArchExclusionLogic;
import br.com.jarch.core.crud.entity.BaseMultiTenantEntity_;
import br.com.jarch.core.crud.entity.CrudEntity_;
import br.com.jarch.core.crud.repository.BaseRepository;
import br.com.jarch.core.crud.search.IPaginator;
import br.com.jarch.core.crud.search.ISearch;
import br.com.jarch.core.crud.search.Paginator;
import br.com.jarch.core.exception.ValidationException;
import br.com.jarch.core.jpa.api.AggregateJpql;
import br.com.jarch.core.jpa.api.ClientJpql;
import br.com.jarch.core.jpa.api.ClientJpqlBuilder;
import br.com.jarch.core.jpa.api.JoinFetch;
import br.com.jarch.core.jpa.param.ParamFieldValueBuilder;
import br.com.jarch.core.jpa.param.ParamFieldValues;
import br.com.jarch.core.jpa.type.FieldOrder;
import br.com.jarch.core.model.IIdentity;
import br.com.jarch.core.model.IMultiTenantEntity;
import br.com.jarch.core.model.MultiTenant;
import br.com.jarch.core.model.UserInformation;
import br.com.jarch.core.type.EntityGraphType;
import br.com.jarch.core.type.FieldType;
import br.com.jarch.core.type.LoadCrudType;
import br.com.jarch.core.util.EntityManagerFilterUtils;
import br.com.jarch.core.util.JpaUtils;
import br.com.jarch.core.util.JpqlUtils;
import br.com.jarch.core.wrapper.LongWrapper;
import br.com.jarch.util.CollectionUtils;
import br.com.jarch.util.ReflectionUtils;
import br.com.jarch.util.StringUtils;
import jakarta.enterprise.event.Event;
import jakarta.enterprise.inject.spi.CDI;
import jakarta.inject.Inject;
import jakarta.persistence.EntityManager;
import jakarta.persistence.LockModeType;
import jakarta.persistence.Query;
import jakarta.persistence.TypedQuery;
import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.CriteriaQuery;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.Order;
import jakarta.persistence.criteria.Predicate;
import jakarta.persistence.criteria.Root;
import jakarta.persistence.criteria.Selection;
import jakarta.persistence.metamodel.Attribute;
import jakarta.transaction.Transactional;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.sql.Connection;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;

public abstract class BaseJpaRepository<E extends IIdentity>
implements BaseRepository<E> {
    private static final String HINT_FETCHGRAPH = "javax.persistence.fetchgraph";
    private static final String HINT_LOADGRAPH = "javax.persistence.loadgraph";
    @Inject
    @JArchEventReadEntityManager
    private transient Event<EntityManager> eventProduceEntityManager;
    @Inject
    @JArchEventLoadCrud(value=LoadCrudType.CLONE)
    private transient Event<E> eventLoadCrudClone;
    @Inject
    @JArchEventLoadCrud(value=LoadCrudType.CHANGE)
    private transient Event<E> eventLoadCrudChange;
    @Inject
    @JArchEventLoadCrud(value=LoadCrudType.CONSULT)
    private transient Event<E> eventLoadCrudConsult;
    @Inject
    @JArchEventLoadCrud(value=LoadCrudType.DELETE)
    private transient Event<E> eventLoadCrudDelete;
    @Inject
    @JArchEventLoadCrud(value=LoadCrudType.ANY)
    private transient Event<E> eventLoadCrudAny;
    @Inject
    @JArchEventSearchAfter
    private transient Event<ISearch<E>> eventSearchAfter;
    private transient EntityManager entityManager;
    private transient String idDynamic;

    protected ClientJpql<E> getClientJpql() {
        return ClientJpqlBuilder.newInstance(this.getClassEntity());
    }

    @Override
    public Class<E> getClassEntity() {
        return ReflectionUtils.getGenericClass(this.getClass(), (int)0);
    }

    protected MultiTenant getMultiTenant() {
        return MultiTenant.getInstance();
    }

    protected UserInformation getUserInformation() {
        return UserInformation.getInstance();
    }

    @Override
    public String getIdDynamic() {
        return this.idDynamic;
    }

    @Override
    public void setIdDynamic(String idDynamic) {
        this.idDynamic = idDynamic;
    }

    @Override
    public EntityManager getEntityManager() {
        if (this.entityManager == null) {
            this.entityManager = (EntityManager)CDI.current().select(EntityManager.class, new Annotation[0]).get();
        }
        EntityManagerFilterUtils.addFilters(this.entityManager);
        this.eventProduceEntityManager.fire((Object)this.entityManager);
        return this.entityManager;
    }

    @Override
    public void clearAllCache() {
        this.getEntityManager().getEntityManagerFactory().getCache().evictAll();
    }

    @Override
    public void clearCache() {
        this.getEntityManager().getEntityManagerFactory().getCache().evict(this.getClassEntity());
    }

    @Override
    public long count() {
        CriteriaBuilder builder = this.getEntityManager().getCriteriaBuilder();
        CriteriaQuery countQuery = builder.createQuery(Long.class);
        Root root = countQuery.from(this.getClassEntity());
        countQuery.select((Selection)builder.count((Expression)root));
        TypedQuery query = this.getEntityManager().createQuery(countQuery);
        query = JpaUtils.createQueryCache(this.getClassEntity(), query);
        return (Long)query.getSingleResult();
    }

    @Override
    public long countBy(ParamFieldValues paramFieldValues) {
        return this.count(paramFieldValues, false);
    }

    @Override
    public long countBy(ISearch<E> search) {
        String jpql = JpqlUtils.selectCount() + " ";
        jpql = jpql + JpqlUtils.from(this.getClassEntity()) + " ";
        jpql = jpql + search.generateClauseWhere();
        TypedQuery query = this.getEntityManager().createQuery(jpql, Long.class);
        query = JpaUtils.createQueryCache(this.getClassEntity(), query);
        search.addValueFilterAndParam((Query)query);
        Long total = (Long)query.getSingleResult();
        int intExact = Math.toIntExact(total);
        if (search.getTotalManipulated() > 0L && (long)intExact > search.getTotalManipulated()) {
            search.setTotal((int)search.getTotalManipulated());
        } else {
            search.setTotal(intExact);
        }
        return total;
    }

    @Override
    public <V> long countBy(Attribute<? super E, V> field, V value) {
        return this.countBy(field.getName(), value);
    }

    @Override
    public long countBy(String field, Object value) {
        return this.countBy(ParamFieldValueBuilder.newInstance(this.getClassEntity()).addFieldValueEqual(field, value).build());
    }

    @Override
    public long countWithCacheBy(ParamFieldValues paramFieldValues) {
        return this.count(paramFieldValues, true);
    }

    @Override
    public boolean exists() {
        return this.count() > 0L;
    }

    @Override
    public boolean notExists() {
        return !this.exists();
    }

    @Override
    public boolean existsBy(ParamFieldValues paramFieldValues) {
        return this.countBy(paramFieldValues) > 0L;
    }

    @Override
    public boolean notExistsBy(ParamFieldValues paramFieldValues) {
        return !this.existsBy(paramFieldValues);
    }

    @Override
    public <V> boolean existsBy(Attribute<? super E, V> field, V value) {
        return this.existsBy(field.getName(), value);
    }

    @Override
    public <V> boolean notExistsBy(Attribute<? super E, V> field, V value) {
        return !this.existsBy(field, value);
    }

    @Override
    public boolean existsBy(String field, Object value) {
        return this.countBy(ParamFieldValueBuilder.newInstance(this.getClassEntity()).addFieldValueEqual(field, value).build()) > 0L;
    }

    @Override
    public boolean notExistsBy(String field, Object value) {
        return !this.existsBy(field, value);
    }

    @Override
    public boolean existsOneBy(ParamFieldValues paramFieldValues) {
        return this.countBy(paramFieldValues) == 1L;
    }

    @Override
    public boolean notExistsOneBy(ParamFieldValues paramFieldValues) {
        return !this.existsOneBy(paramFieldValues);
    }

    @Override
    public boolean existsOneBy(String field, Object value) {
        return this.existsOneBy(ParamFieldValueBuilder.newInstance(this.getClassEntity()).addFieldValueEqual(field, value).build());
    }

    @Override
    public boolean notExistsOneBy(String field, Object value) {
        return !this.existsOneBy(field, value);
    }

    @Override
    public E find(Long id) {
        return (E)((IIdentity)this.getEntityManager().find(this.getClassEntity(), (Object)id));
    }

    @Override
    public Optional<E> findAny(Long id) {
        IIdentity result = (IIdentity)this.getEntityManager().find(this.getClassEntity(), (Object)id);
        if (result == null) {
            return Optional.empty();
        }
        return Optional.of(result);
    }

    @Override
    public E find(Long id, Map<String, Object> properties) {
        return (E)((IIdentity)this.getEntityManager().find(this.getClassEntity(), (Object)id, properties));
    }

    @Override
    public E find(Long id, LockModeType lockMode) {
        return (E)((IIdentity)this.getEntityManager().find(this.getClassEntity(), (Object)id, lockMode));
    }

    @Override
    public E find(Long id, LockModeType lockMode, Map<String, Object> properties) {
        return (E)((IIdentity)this.getEntityManager().find(this.getClassEntity(), (Object)id, lockMode, properties));
    }

    @Override
    public E findWithFetchGraphBy(Long id, String graphName) {
        return (E)((IIdentity)this.getEntityManager().find(this.getClassEntity(), (Object)id, this.getMapFetchGraph(graphName)));
    }

    @Override
    public E findWithLoadGraphBy(Long id, String graphName) {
        return (E)((IIdentity)this.getEntityManager().find(this.getClassEntity(), (Object)id, this.getMapLoadGraph(graphName)));
    }

    @Override
    public Collection<E> searchAll() {
        String jpql = JpqlUtils.from(this.getClassEntity()) + " ";
        TypedQuery query = this.getEntityManager().createQuery(jpql, this.getClassEntity());
        query = JpaUtils.createQueryCache(this.getClassEntity(), query);
        return query.getResultList();
    }

    @Override
    public Collection<E> searchAllBy(Map<String, Object> filters, boolean caseSensitive) {
        String classEntity = JpqlUtils.aliasEntity(this.getClassEntity());
        StringBuilder jpql = new StringBuilder(JpqlUtils.from(this.getClassEntity()).concat(" "));
        String where = filters.keySet().stream().map(o -> (caseSensitive ? "" : "LOWER(") + classEntity + "." + o + (caseSensitive ? "" : ")") + " = " + (caseSensitive ? "" : "LOWER(") + ":" + o.replace(".", "") + (caseSensitive ? "" : ")")).collect(Collectors.joining(" AND "));
        if (!where.isEmpty()) {
            jpql.append("WHERE ".concat(where));
        }
        TypedQuery query = this.getEntityManager().createQuery(jpql.toString(), this.getClassEntity());
        query = JpaUtils.createQueryCache(this.getClassEntity(), query);
        for (Map.Entry<String, Object> keyValue : filters.entrySet()) {
            query.setParameter(keyValue.getKey().replace(".", ""), keyValue.getValue());
        }
        return query.getResultList();
    }

    @Override
    public Collection<E> searchAllBy(Map<String, Object> filters) {
        return this.searchAllBy(filters, true);
    }

    @Override
    public Collection<E> searchAllBy(ParamFieldValues paramFieldValues, FieldOrder fieldOrder) {
        String jpql = JpqlUtils.from(this.getClassEntity()) + " ";
        jpql = jpql + JpqlUtils.where(this.getClassEntity(), paramFieldValues, List.of()) + " ";
        if (fieldOrder != null) {
            jpql = jpql + JpqlUtils.orderBy(this.getClassEntity(), fieldOrder);
        }
        TypedQuery query = this.getEntityManager().createQuery(jpql, this.getClassEntity());
        query = JpaUtils.createQueryCache(this.getClassEntity(), query);
        JpqlUtils.addValueParam(query, paramFieldValues);
        return query.getResultList();
    }

    @Override
    public Collection<E> searchAllBy(ParamFieldValues paramFieldValues, Collection<JoinFetch<?>> joinFetchs) {
        String jpql = JpqlUtils.from(this.getClassEntity(), joinFetchs) + " ";
        jpql = jpql + JpqlUtils.where(this.getClassEntity(), paramFieldValues) + " ";
        TypedQuery query = this.getEntityManager().createQuery(jpql, this.getClassEntity());
        query = JpaUtils.createQueryCache(this.getClassEntity(), query);
        JpqlUtils.addValueParam(query, paramFieldValues);
        return query.getResultList();
    }

    @Override
    public Collection<E> searchAllBy(ParamFieldValues paramFieldValues, FieldOrder fieldOrder, Collection<JoinFetch<?>> joinFetchs) {
        String jpql = JpqlUtils.from(this.getClassEntity(), joinFetchs) + " ";
        jpql = jpql + JpqlUtils.where(this.getClassEntity(), paramFieldValues) + " ";
        if (fieldOrder != null) {
            jpql = jpql + JpqlUtils.orderBy(this.getClassEntity(), fieldOrder);
        }
        TypedQuery query = this.getEntityManager().createQuery(jpql, this.getClassEntity());
        query = JpaUtils.createQueryCache(this.getClassEntity(), query);
        JpqlUtils.addValueParam(query, paramFieldValues);
        return query.getResultList();
    }

    private static Collection<JoinFetch<?>> getAliases(JoinFetch<?>[] joinFetches) {
        return joinFetches == null ? List.of() : (Collection)Arrays.stream(joinFetches).collect(Collectors.toList());
    }

    @Override
    public <T> Collection<T> searchAllBy(ISearch<E> search) {
        if (search == null) {
            throw new IllegalArgumentException("Search parameter cannot be null");
        }
        Class<?> resultClass = search.getClassReturn();
        return this.searchAllBy(search, resultClass);
    }

    @Override
    public <T> Collection<T> searchAllBy(ISearch<E> search, Class<T> classResult) {
        search.setFirst(0);
        search.setMaxResults(0);
        return this.searchAllWithPaginatorBy(search, classResult).getList();
    }

    @Override
    public Collection<E> searchAllBy(String field, Object value) {
        return this.searchAllBy(field, value, true);
    }

    @Override
    public Collection<E> searchAllBy(String field, Object value, Collection<JoinFetch<?>> joinFetches) {
        return this.searchAllBy(ParamFieldValueBuilder.newInstance(this.getClassEntity()).addFieldValueEqual(field, value).build(), joinFetches);
    }

    @Override
    public Collection<E> searchAllBy(String field, Object value, boolean caseSensitive) {
        return this.searchAllBy(field, value, null, caseSensitive);
    }

    @Override
    public Collection<E> searchAllBy(String field, Object value, FieldOrder fieldOrder, boolean caseSensitive) {
        return this.searchAllBy(ParamFieldValueBuilder.newInstance(this.getClassEntity()).addFieldValueEqual(field, value, caseSensitive).build(), fieldOrder);
    }

    @Override
    public Collection<E> searchAllBy(ParamFieldValues paramFieldValues) {
        return this.searchAllBy(paramFieldValues, null, null);
    }

    @Override
    public Collection<E> searchAllBy(String field, Object value, FieldOrder fieldOrder) {
        return this.searchAllBy(field, value, fieldOrder, true);
    }

    @Override
    public <V> Collection<E> searchAllBy(Attribute<? super E, V> field, V value) {
        return this.searchAllBy(field.getName(), value);
    }

    @Override
    public <V> Collection<E> searchAllBy(Attribute<? super E, V> field, V value, Collection<JoinFetch<?>> joinFetches) {
        return this.searchAllBy(field.getName(), value, joinFetches);
    }

    @Override
    public <V> Collection<E> searchAllBy(Attribute<? super E, V> field, Collection<V> values) {
        return this.searchAllBy(field.getName(), values);
    }

    @Override
    public <T> Optional<T> searchAnyBy(ISearch<E> search) {
        return this.searchAnyBy(search, search.getClassReturn());
    }

    @Override
    public <T> Optional<T> searchAnyBy(ISearch<E> search, Class<T> classResult) {
        return this.searchAllBy(search, classResult).stream().findAny();
    }

    @Override
    public Optional<E> searchAnyBy(Map<String, Object> mapParamValue) {
        return this.searchAllBy(mapParamValue).stream().findAny();
    }

    @Override
    public Optional<E> searchAnyBy(ParamFieldValues paramFieldValues, FieldOrder fieldOrder) {
        return this.searchAllBy(paramFieldValues, fieldOrder).stream().findAny();
    }

    @Override
    public Optional<E> searchAnyBy(Map<String, Object> mapParamValue, boolean caseSensitive) {
        return this.searchAllBy(mapParamValue, caseSensitive).stream().findAny();
    }

    @Override
    public Optional<E> searchAnyBy(String field, Object value) {
        return this.searchAllBy(field, value).stream().findAny();
    }

    @Override
    public Optional<E> searchAnyBy(String field, Object value, Collection<JoinFetch<?>> joinFetches) {
        return this.searchAllBy(field, value, joinFetches).stream().findAny();
    }

    @Override
    public <V> Optional<E> searchAnyBy(Attribute<? super E, V> field, V value) {
        return this.searchAllBy(field.getName(), value).stream().findAny();
    }

    @Override
    public <V> Optional<E> searchAnyBy(Attribute<? super E, V> field, V value, Collection<JoinFetch<?>> joinFetches) {
        return this.searchAllBy(field.getName(), value, joinFetches).stream().findAny();
    }

    @Override
    public Optional<E> searchAnyBy(String field, Object value, boolean caseSensitive) {
        return this.searchAllBy(field, value, caseSensitive).stream().findAny();
    }

    @Override
    public Optional<E> searchAnyBy(String field, Object value, FieldOrder fieldOrder, boolean caseSensitive) {
        return this.searchAllBy(field, value, fieldOrder, caseSensitive).stream().findAny();
    }

    @Override
    public Optional<E> searchAnyBy(ParamFieldValues paramFieldValues) {
        return this.searchAllBy(paramFieldValues).stream().findAny();
    }

    @Override
    public <T> IPaginator<T> searchAllWithPaginatorBy(ISearch<E> search) {
        return this.searchAllWithPaginatorBy(search, search.getClassReturn());
    }

    @Override
    public <T> IPaginator<T> searchAllWithPaginatorBy(ISearch<E> search, Class<T> classResult) {
        this.applyFilterTenantLogicExclusion(search);
        Paginator paginator = new Paginator();
        paginator.setFirst(search.getFirst());
        paginator.setTotal(search.getTotal());
        if (paginator.getFirst() >= paginator.getTotal() && search.getMaxResults() > 0) {
            paginator.setFirst(paginator.getTotal() / search.getMaxResults() * search.getMaxResults());
        }
        if (paginator.getFirst() == paginator.getTotal()) {
            paginator.setFirst(paginator.getTotal() - search.getMaxResults());
            if (paginator.getFirst() < 0) {
                paginator.setFirst(0);
            }
        }
        Object comandoJpa = this.clauseSelect(search);
        comandoJpa = (String)comandoJpa + JpqlUtils.from(this.getClassEntity()) + " ";
        comandoJpa = (String)comandoJpa + search.generateClauseWhere() + " ";
        comandoJpa = (String)comandoJpa + search.generateClauseOrderBy();
        TypedQuery<T> query = this.getEntityManager().createQuery((String)comandoJpa, classResult);
        query = JpaUtils.createQueryCache(this.getClassEntity(), query);
        query = query.setFirstResult(paginator.getFirst());
        if (search.getMaxResults() > 0) {
            query = query.setMaxResults(search.getMaxResults());
        }
        search.addValueFilterAndParam((Query)query);
        query = this.ajustEntityGraph(query);
        List listaEntidade = query.getResultList();
        paginator.setMaxResults(search.getMaxResults());
        paginator.setList(listaEntidade);
        this.eventSearchAfter.fire(search);
        return paginator;
    }

    private void applyFilterTenantLogicExclusion(ISearch<E> search) {
        if (!MultiTenant.getInstance().isSession() && IMultiTenantEntity.class.isAssignableFrom(this.getClassEntity())) {
            search.newSearchField(FieldType.NUMBER, BaseMultiTenantEntity_.multiTenantId, MultiTenant.getInstance().get());
        }
        if (!MultiTenant.getInstance().isSession() && this.getClassEntity().isAnnotationPresent(JArchExclusionLogic.class)) {
            search.newSearchField(FieldType.DATE_TIME, CrudEntity_.dateHourLogicExclusion, null);
        }
    }

    @Override
    public void execute(String jpql, ISearch<E> search) {
        this.execute(jpql, search, new HashMap<String, Object>());
    }

    @Override
    public void execute(String jpql, ISearch<E> search, Map<String, Object> paramsValues) {
        String commandJpql = jpql + " ";
        commandJpql = commandJpql + JpqlUtils.from(this.getClassEntity()) + " ";
        commandJpql = commandJpql + search.generateClauseWhere();
        Query query = this.getEntityManager().createQuery(commandJpql);
        paramsValues.forEach((arg_0, arg_1) -> ((Query)query).setParameter(arg_0, arg_1));
        search.addValueFilterAndParam(query);
        query.executeUpdate();
    }

    private String clauseSelect(ISearch<E> search) {
        Object jpql = "";
        String nameClassReturn = search.getClassReturn().getName();
        if (!search.getParamsConstructorClassReturn().isEmpty()) {
            jpql = "SELECT ";
            if (StringUtils.isNotEmpty((String)search.getHint())) {
                jpql = (String)jpql + search.getHint() + " ";
            }
            jpql = (String)jpql + "new " + nameClassReturn + "(" + this.getParamsConstructorClassReturnWithAlias(search) + ") ";
        } else if (CollectionUtils.isNotEmpty((Collection)search.getColumnsList())) {
            int countId;
            List constructors = Arrays.stream(search.getClassReturn().getConstructors()).collect(Collectors.toList());
            boolean existIdColumnList = search.getColumnsList().stream().noneMatch(sf -> sf.getField().equals("id"));
            int n = countId = existIdColumnList ? 1 : 0;
            if (!constructors.isEmpty() && constructors.stream().anyMatch(c -> c.getParameterCount() == search.getColumnsList().size() + countId && c.getParameterTypes()[0] == Long.class)) {
                jpql = "SELECT new " + nameClassReturn + "(" + (existIdColumnList ? "id, " : "") + search.getColumnsList().stream().map(c -> c.getSubQuery().isEmpty() ? c.getField() : c.getSubQuery()).collect(Collectors.joining(", ")) + ") ";
            }
        }
        if (search.isRemoveDescriptionJqpl()) {
            String alias = JpqlUtils.aliasEntity(this.getClassEntity());
            String columnDescription = alias.concat(".").concat("description");
            String columnDescriptionTemp = columnDescription.replace(".", "_dont.change_");
            String columnDescricao = alias.concat(".").concat("descricao");
            String columnDescricaoTemp = columnDescricao.replace(".", "_dont.change_");
            jpql = ((String)jpql).replace(columnDescription, columnDescriptionTemp);
            jpql = ((String)jpql).replace(columnDescricao, columnDescricaoTemp);
            jpql = ((String)jpql).replace(".description,", ",");
            jpql = ((String)jpql).replace(".description)", ")");
            jpql = ((String)jpql).replace(".descricao,", ",");
            jpql = ((String)jpql).replace(".descricao)", ")");
            jpql = ((String)jpql).replace(columnDescriptionTemp, columnDescription);
            jpql = ((String)jpql).replace(columnDescricaoTemp, columnDescricao);
        }
        return jpql;
    }

    private String getParamsConstructorClassReturnWithAlias(ISearch<E> search) {
        List<String> paramsConstructor = search.getParamsConstructorClassReturn();
        String alias = JpqlUtils.aliasEntity(this.getClassEntity());
        Object result = paramsConstructor.stream().map(f -> (String)(f.trim().contains("(") || f.trim().startsWith(alias + ".") || f.toLowerCase().trim().startsWith("case") ? "" : alias + ".") + f).collect(Collectors.joining(", "));
        if (!((String)result).isBlank() && !search.isTotalize()) {
            result = alias + ".id, " + (String)result;
        }
        return result;
    }

    private <T> TypedQuery<T> ajustEntityGraph(TypedQuery<T> query) {
        JArchEntityGraphSearchList jarchEntityGraphSearchList = this.getClassEntity().getAnnotation(JArchEntityGraphSearchList.class);
        if (jarchEntityGraphSearchList != null) {
            query = EntityGraphType.FETCH.equals((Object)jarchEntityGraphSearchList.type()) ? query.setHint(HINT_FETCHGRAPH, (Object)this.getEntityManager().getEntityGraph(jarchEntityGraphSearchList.name())) : query.setHint(HINT_LOADGRAPH, (Object)this.getEntityManager().getEntityGraph(jarchEntityGraphSearchList.name()));
        }
        return query;
    }

    @Override
    public Collection<E> searchAllOrderBy(FieldOrder fieldOrder) {
        CriteriaBuilder builder = this.getEntityManager().getCriteriaBuilder();
        CriteriaQuery criteriaQuery = builder.createQuery(this.getClassEntity());
        Root root = criteriaQuery.from(this.getClassEntity());
        criteriaQuery.select((Selection)root);
        if (fieldOrder != null && !fieldOrder.getField().isEmpty()) {
            if (fieldOrder.isAsc()) {
                criteriaQuery.orderBy(new Order[]{builder.asc((Expression)root.get(fieldOrder.getField()))});
            } else {
                criteriaQuery.orderBy(new Order[]{builder.desc((Expression)root.get(fieldOrder.getField()))});
            }
        }
        TypedQuery query = this.getEntityManager().createQuery(criteriaQuery);
        query = JpaUtils.createQueryCache(this.getClassEntity(), query);
        return query.getResultList();
    }

    @Override
    public E searchOneBy(String field, Object value) {
        return this.searchOneBy(ParamFieldValueBuilder.newInstance(this.getClassEntity()).addFieldValueEqual(field, value).build(), List.of());
    }

    @Override
    public <V> E searchOneBy(Attribute<? super E, V> field, V value) {
        return this.searchOneBy(ParamFieldValueBuilder.newInstance(this.getClassEntity()).addFieldValueEqual(field.getName(), value).build(), List.of());
    }

    @Override
    public <V> E searchOneBy(Attribute<? super E, V> field, V value, Collection<JoinFetch<?>> joinFetches) {
        ParamFieldValues paramFieldValues = ParamFieldValueBuilder.newInstance(this.getClassEntity()).addFieldValueEqual(field.getName(), value).build();
        return this.searchOneBy(paramFieldValues, joinFetches);
    }

    @Override
    public E searchOneBy(Predicate predicate) {
        CriteriaBuilder builder = this.getEntityManager().getEntityManagerFactory().getCriteriaBuilder();
        CriteriaQuery criteria = builder.createQuery(this.getClassEntity());
        Root root = criteria.from(this.getClassEntity());
        criteria.select((Selection)root);
        criteria.where((Expression)predicate);
        TypedQuery query = this.getEntityManager().createQuery(criteria);
        query = JpaUtils.createQueryCache(this.getClassEntity(), query);
        return (E)((IIdentity)query.getSingleResult());
    }

    @Override
    public E searchOneBy(Map<String, Object> filters) {
        return this.searchOneBy(filters, true);
    }

    @Override
    public E searchOneBy(Map<String, Object> filters, boolean caseSensitive) {
        String classEntity = JpqlUtils.aliasEntity(this.getClassEntity());
        StringBuilder jpql = new StringBuilder(JpqlUtils.from(this.getClassEntity()).concat(" "));
        String where = filters.keySet().stream().map(o -> (caseSensitive ? "" : "LOWER(") + classEntity + "." + o + (caseSensitive ? "" : ")") + " = " + (caseSensitive ? "" : "LOWER(") + ":" + o.replace(".", "") + (caseSensitive ? "" : ")")).collect(Collectors.joining(" AND "));
        if (!where.isEmpty()) {
            jpql.append("WHERE ".concat(where));
        }
        TypedQuery query = this.getEntityManager().createQuery(jpql.toString(), this.getClassEntity());
        query = JpaUtils.createQueryCache(this.getClassEntity(), query);
        for (Map.Entry<String, Object> keyValue : filters.entrySet()) {
            query.setParameter(keyValue.getKey().replace(".", ""), keyValue.getValue());
        }
        return (E)((IIdentity)query.getSingleResult());
    }

    @Override
    public E searchOneBy(ParamFieldValues paramFieldValues) {
        return this.searchOneBy(paramFieldValues, List.of());
    }

    @Override
    public E searchOneBy(ParamFieldValues paramFieldValues, Collection<JoinFetch<?>> joinFetchList) {
        String jpql = JpqlUtils.from(this.getClassEntity(), joinFetchList) + " ";
        jpql = jpql + JpqlUtils.where(this.getClassEntity(), paramFieldValues, joinFetchList);
        TypedQuery query = this.getEntityManager().createQuery(jpql, this.getClassEntity());
        query = JpaUtils.createQueryCache(this.getClassEntity(), query);
        JpqlUtils.addValueParam(query, paramFieldValues);
        return (E)((IIdentity)query.getSingleResult());
    }

    @Override
    public E searchWithJpqlSingleResult(String jpql, Map<String, Object> mapParamValue) {
        TypedQuery query = this.getEntityManager().createQuery(jpql, this.getClassEntity());
        query = JpaUtils.forceCache(query);
        JpqlUtils.addValueParam(query, mapParamValue);
        return (E)((IIdentity)query.getSingleResult());
    }

    @Override
    public Collection<E> searchWithJpqlResultList(String jpql, Map<String, Object> mapParamValue) {
        TypedQuery query = this.getEntityManager().createQuery(jpql, this.getClassEntity());
        query = JpaUtils.forceCache(query);
        JpqlUtils.addValueParam(query, mapParamValue);
        return query.getResultList();
    }

    @Override
    @Transactional
    public E searchOneAndInitializeCollectionsBy(Long id) {
        E entity = this.find(id);
        JpaUtils.initializeCollectionLazy(entity);
        return entity;
    }

    @Override
    @Transactional
    public E searchOneAndInitializeCollectionsBy(String field, Object value) {
        E entity = this.searchOneBy(field, value);
        JpaUtils.initializeCollectionLazy(entity);
        return entity;
    }

    @Override
    @Transactional
    public E loadCrud(Long id) {
        return this.loadCrud(id, null);
    }

    @Override
    @Transactional
    public E loadCrud(Long id, String logic) {
        return this.loadCrud(id, logic, LoadCrudType.ANY);
    }

    @Override
    @Transactional
    public E loadCrud(Long id, String logic, LoadCrudType loadCrud) {
        JArchEntityGraphLoadCrud annotation = this.getClassEntity().getAnnotation(JArchEntityGraphLoadCrud.class);
        E e = annotation == null ? this.searchOneBy("id", id) : (EntityGraphType.FETCH.equals((Object)annotation.type()) ? this.findWithFetchGraphBy(id, annotation.name()) : this.findWithLoadGraphBy(id, annotation.name()));
        if (e != null) {
            e.setLogicFrom(logic);
            Optional<String> logicFrom = Optional.ofNullable(logic);
            if (logicFrom.isEmpty() || !logicFrom.get().equals("JARCH_EVENT_FIELD_CHANGE")) {
                this.callEventLoadCrud(loadCrud, e);
            }
        }
        return e;
    }

    private void callEventLoadCrud(LoadCrudType type, E e) {
        if (LoadCrudType.CLONE.equals((Object)type)) {
            this.eventLoadCrudClone.fire(e);
        } else if (LoadCrudType.CHANGE.equals((Object)type)) {
            this.eventLoadCrudChange.fire(e);
        } else if (LoadCrudType.CONSULT.equals((Object)type)) {
            this.eventLoadCrudConsult.fire(e);
        } else if (LoadCrudType.DELETE.equals((Object)type)) {
            this.eventLoadCrudDelete.fire(e);
        }
        this.eventLoadCrudAny.fire(e);
    }

    @Override
    @Transactional
    public E loadCrudAndDetach(Long id) {
        return this.loadCrudAndDetach(id, null);
    }

    @Override
    @Transactional
    public E loadCrudAndDetach(Long id, String logic) {
        return this.loadCrudAndDetach(id, logic, LoadCrudType.ANY);
    }

    @Override
    @Transactional
    public E loadCrudAndDetach(Long id, String logic, LoadCrudType loadCrud) {
        Optional<String> logicFrom = Optional.ofNullable(logic);
        E e = this.find(id);
        e.setLogicFrom(logicFrom.orElse(null));
        this.callEventLoadCrud(loadCrud, e);
        this.getEntityManager().detach(e);
        return e;
    }

    @Override
    public Connection getConnection() {
        return JpqlUtils.getConnection(this.getEntityManager());
    }

    @Override
    public Long minId() {
        return this.getClientJpql().select(AggregateJpql.min("id")).collect().any(LongWrapper.class).orElse(new LongWrapper(0)).getLongValue();
    }

    @Override
    public Long maxId() {
        return this.getClientJpql().select(AggregateJpql.max("id")).collect().any(LongWrapper.class).orElse(new LongWrapper(0)).getLongValue();
    }

    private Map<String, Object> getMapFetchGraph(String graphName) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(HINT_FETCHGRAPH, this.getEntityManager().getEntityGraph(graphName));
        return map;
    }

    private Map<String, Object> getMapLoadGraph(String graphName) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(HINT_LOADGRAPH, this.getEntityManager().getEntityGraph(graphName));
        return map;
    }

    private long count(ParamFieldValues paramFieldValues, boolean cache) {
        String jpql = JpqlUtils.selectCount() + " ";
        jpql = jpql + JpqlUtils.from(this.getClassEntity()) + " ";
        jpql = jpql + JpqlUtils.where(this.getClassEntity(), paramFieldValues, List.of());
        TypedQuery query = this.getEntityManager().createQuery(jpql, Long.class);
        query = cache ? JpaUtils.forceCache(query) : JpaUtils.createQueryCache(this.getClassEntity(), query);
        JpqlUtils.addValueParam(query, paramFieldValues);
        return (Long)query.getSingleResult();
    }

    @Override
    @Transactional
    public <V> E initializeField(E entity, Attribute<E, V> attribute) {
        try {
            IIdentity entityNew = (IIdentity)this.getEntityManager().merge(entity);
            Field field = ReflectionUtils.getField(this.getClassEntity(), (String)attribute.getName());
            field.setAccessible(true);
            JpaUtils.initialize(field.get(entityNew));
            return (E)entityNew;
        }
        catch (Exception e) {
            throw new ValidationException(e);
        }
    }
}

