/*
 * Decompiled with CFR 0.152.
 */
package br.com.jarch.core.crud.batch;

import br.com.jarch.core.annotation.JArchService;
import br.com.jarch.core.cdi.GlobalInformation;
import br.com.jarch.core.crud.batch.BatchEntity;
import br.com.jarch.core.crud.batch.BatchRepository;
import br.com.jarch.core.crud.batch.BatchService;
import br.com.jarch.core.crud.batch.ExecutionEntity;
import br.com.jarch.core.crud.batch.ExecutionRepository;
import br.com.jarch.core.crud.batch.ExecutionService;
import br.com.jarch.core.crud.batch.LogEntity;
import br.com.jarch.core.crud.batch.LogRepository;
import br.com.jarch.core.crud.service.CrudService;
import br.com.jarch.core.util.EnvironmentUtils;
import br.com.jarch.core.util.ErrorUtils;
import br.com.jarch.util.CharacterUtils;
import br.com.jarch.util.LogUtils;
import br.com.jarch.util.StringUtils;
import jakarta.enterprise.inject.spi.CDI;
import jakarta.transaction.Transactional;
import jakarta.validation.constraints.NotNull;
import java.lang.annotation.Annotation;
import java.net.InetAddress;
import java.time.LocalDateTime;

@JArchService
public class LogService
extends CrudService<LogEntity, LogRepository> {
    public static final String BATCH_EXECUTION_ID = "BATCH.EXECUTION.ID";

    public static LogService getInstance() {
        return (LogService)CDI.current().select(LogService.class, new Annotation[0]).get();
    }

    @Transactional(value=Transactional.TxType.REQUIRES_NEW)
    public void startExecution(String codeBatch, String nameBatch) {
        if (this.isExecutionContext()) {
            LogUtils.generate((String)("CONTEXTO J\u00c1 INICIADO ANTERIORMENTE (" + codeBatch + " / " + nameBatch + ")"));
            return;
        }
        BatchEntity batch = this.searchOrCreateBatch(codeBatch, nameBatch);
        this.createExecution(batch);
    }

    private void createExecution(BatchEntity batch) {
        ExecutionEntity execution = (ExecutionEntity)ExecutionService.getInstance().createEntity();
        execution.setBatch(batch);
        execution.setStartTime(LocalDateTime.now());
        ExecutionService.getInstance().insert(execution);
        LogService.saveExecutionContext(execution);
        String logStart = "Iniciando Processamento: IP: " + LogService.getIp() + " / WAR: " + this.getNameWar();
        this.addLog(logStart);
    }

    private BatchEntity searchOrCreateBatch(String code, String name) {
        BatchEntity batch = BatchRepository.getInstance().searchBy(code, name).orElse(new BatchEntity(null, code, name));
        if (batch.getId() == null) {
            BatchService.getInstance().insert(batch);
        }
        return batch;
    }

    @Transactional(value=Transactional.TxType.REQUIRES_NEW)
    public void addLogLimit500Bytes(@NotNull String information) {
        this.save(information.length() > 500 ? information.substring(0, 500) : information);
    }

    @Transactional(value=Transactional.TxType.REQUIRES_NEW)
    public void addLog(Exception exception) {
        String messageError = ErrorUtils.messageErro(exception);
        this.save(messageError);
    }

    @Transactional(value=Transactional.TxType.REQUIRES_NEW)
    public void addLog(String information) {
        this.save(information);
    }

    private void save(String information) {
        if (this.isExecutionContext()) {
            LogUtils.generate((String)information);
        } else if (this.isNotExecutionContext()) {
            LogUtils.generate((String)(information + " (Contexto LOG N\u00c3O INICIADO)"));
            return;
        }
        if (StringUtils.isNullOrEmpty((String)information)) {
            information = "Descri\u00e7\u00e3o do LOG NULL ou N\u00c3O INFORMADO";
        }
        for (String value : CharacterUtils.splitSize((String)information, (int)500)) {
            LogEntity log = (LogEntity)this.createEntity();
            log.setTimeLog(LocalDateTime.now());
            log.setInformation(value);
            ExecutionEntity execution = (ExecutionEntity)ExecutionRepository.getInstance().find(LogService.recoverExecutionContext());
            log.setExecution(execution);
            this.insert(log);
        }
    }

    @Transactional(value=Transactional.TxType.REQUIRES_NEW)
    public void success(String log) {
        if (this.isExecutionContext()) {
            LogUtils.generate((String)log);
        } else if (this.isNotExecutionContext()) {
            LogUtils.generate((String)(log + " (Contexto LOG N\u00c3O INICIADO)"));
            return;
        }
        this.addLog(log);
        this.recordExecutionEndWithSuccess(log);
    }

    @Transactional(value=Transactional.TxType.REQUIRES_NEW)
    public void success() {
        if (this.isNotExecutionContext()) {
            LogUtils.generate((String)"Contexto LOG N\u00c3O INICIADO");
            return;
        }
        this.recordExecutionEndWithSuccess("Fim do Processamento com SUCESSO");
    }

    private void recordExecutionEndWithSuccess(String logEndSucess) {
        this.addLog(logEndSucess);
        ExecutionEntity execution = (ExecutionEntity)ExecutionRepository.getInstance().find(LogService.recoverExecutionContext());
        execution.setSuccess(true);
        execution.setEndTime(LocalDateTime.now());
        ExecutionService.getInstance().change(execution);
        LogService.removeExecutionContext();
    }

    public void error(Exception exception) {
        String messageError = ErrorUtils.messageErro(exception);
        this.error(messageError);
    }

    @Transactional(value=Transactional.TxType.REQUIRES_NEW)
    public void error(String erro) {
        if (this.isNotExecutionContext()) {
            LogUtils.generate((String)(erro + " (Contexto LOG N\u00c3O INICIADO)"));
            return;
        }
        this.addLog(erro);
        this.recordExecutionEndWithFailure();
    }

    private void recordExecutionEndWithFailure() {
        this.addLog("Fim do Processamento com ERRO");
        ExecutionEntity execution = (ExecutionEntity)ExecutionRepository.getInstance().find(LogService.recoverExecutionContext());
        execution.setSuccess(false);
        execution.setEndTime(LocalDateTime.now());
        ExecutionService.getInstance().change(execution);
        LogService.removeExecutionContext();
    }

    @Transactional(value=Transactional.TxType.REQUIRES_NEW)
    public void error() {
        if (this.isNotExecutionContext()) {
            LogUtils.generate((String)"Contexto LOG N\u00c3O INICIADO");
            return;
        }
        this.recordExecutionEndWithFailure();
    }

    private static void removeExecutionContext() {
        GlobalInformation.getInstance().remove(BATCH_EXECUTION_ID);
    }

    private static void saveExecutionContext(ExecutionEntity execution) {
        GlobalInformation.getInstance().set(BATCH_EXECUTION_ID, execution.getId());
    }

    private static Long recoverExecutionContext() {
        return (Long)GlobalInformation.getInstance().get(BATCH_EXECUTION_ID);
    }

    public boolean isNotExecutionContext() {
        return GlobalInformation.getInstance().get(BATCH_EXECUTION_ID) == null;
    }

    public boolean isExecutionContext() {
        return GlobalInformation.getInstance().get(BATCH_EXECUTION_ID) != null;
    }

    private String getNameWar() {
        return EnvironmentUtils.getNameWar(this.getClass());
    }

    private static String getIp() {
        try {
            return InetAddress.getLocalHost().getHostAddress();
        }
        catch (Exception e) {
            LogUtils.generate((Throwable)e);
            return "N\u00e3o Identificado";
        }
    }

    public void deleteExpired() {
        BatchRepository.getInstance().deleteAllBefore(LocalDateTime.now().minusDays(30L));
    }

    public void markErrorWithoutEnd(String codeBatch) {
        ExecutionRepository.getInstance().markErrorWithoutEnd(codeBatch);
    }
}

