/*
 * Decompiled with CFR 0.152.
 */
package br.com.jarch.apt.processor;

import br.com.jarch.apt.util.ProcessorUtils;
import br.com.jarch.core.annotation.JArchLookup;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.Completion;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;

@SupportedAnnotationTypes(value={"br.com.jarch.core.annotation.JArchLookup"})
public class LookupProcessor
extends AbstractProcessor {
    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        try {
            ProcessorUtils.processingEnvironment = this.processingEnv;
            ProcessorUtils.messageNote("Analyzing: " + this.getClass().getSimpleName());
            for (Element element : roundEnv.getElementsAnnotatedWith(JArchLookup.class)) {
                ProcessorUtils.messageAnalyzing(this.getClass(), element);
                JArchLookup anotacao = element.getAnnotation(JArchLookup.class);
                if (anotacao.ignoreProcessor()) continue;
                TypeElement classeElement = (TypeElement)element;
                LookupProcessor.existsFieldLookup(element, classeElement, anotacao.codeAttribute());
                LookupProcessor.existsFieldLookup(element, classeElement, anotacao.descriptionAttribute());
            }
        }
        catch (Exception ex) {
            ProcessorUtils.messageError("JARCH ERROR: Erro no APT " + this.getClass().getSimpleName() + " Mensagem: " + ex.getMessage());
        }
        return false;
    }

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latest();
    }

    private static void existsFieldLookup(Element elementAtual, TypeElement classeElement, String field) {
        if (!ProcessorUtils.existsField(classeElement, field)) {
            ProcessorUtils.messageError("JARCH ERROR: Atributo " + field + " n\u00e3o localizado na anota\u00e7\u00e3o @JArchLookup da classe " + classeElement.getQualifiedName().toString(), elementAtual);
        }
    }

    @Override
    public Iterable<? extends Completion> getCompletions(Element element, AnnotationMirror annotation, ExecutableElement member, String userText) {
        return super.getCompletions(element, annotation, member, userText);
    }
}

