/*
 * Decompiled with CFR 0.152.
 */
package jakarta.faces.model;

import jakarta.faces.model.DataModel;
import jakarta.faces.model.DataModelEvent;
import jakarta.faces.model.DataModelListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public class IterableDataModel<E>
extends DataModel<E> {
    private int index = -1;
    private Iterable<E> iterable;
    private List<E> list;

    public IterableDataModel() {
        this(null);
    }

    public IterableDataModel(Iterable<E> iterable) {
        this.setWrappedData(iterable);
    }

    @Override
    public boolean isRowAvailable() {
        return this.list != null && this.index >= 0 && this.index < this.list.size();
    }

    @Override
    public int getRowCount() {
        if (this.list == null) {
            return -1;
        }
        return this.list.size();
    }

    @Override
    public E getRowData() {
        if (this.list == null) {
            return null;
        }
        if (!this.isRowAvailable()) {
            throw new IllegalArgumentException();
        }
        return this.list.get(this.index);
    }

    @Override
    public int getRowIndex() {
        return this.index;
    }

    @Override
    public void setRowIndex(int rowIndex) {
        if (rowIndex < -1) {
            throw new IllegalArgumentException();
        }
        int oldRowIndex = this.index;
        this.index = rowIndex;
        if (this.list == null) {
            return;
        }
        this.notifyListeners(oldRowIndex, rowIndex);
    }

    @Override
    public Object getWrappedData() {
        return this.iterable;
    }

    @Override
    public void setWrappedData(Object data) {
        if (data == null) {
            this.iterable = null;
            this.list = null;
            this.setRowIndex(-1);
        } else {
            this.iterable = (Iterable)data;
            this.list = IterableDataModel.iterableToList(this.iterable);
            this.setRowIndex(0);
        }
    }

    private E getRowDataOrNull() {
        if (this.isRowAvailable()) {
            return this.getRowData();
        }
        return null;
    }

    private void notifyListeners(int oldRowIndex, int rowIndex) {
        DataModelListener[] dataModelListeners = this.getDataModelListeners();
        if (oldRowIndex != rowIndex && dataModelListeners != null) {
            DataModelEvent dataModelEvent = new DataModelEvent(this, rowIndex, this.getRowDataOrNull());
            for (DataModelListener dataModelListener : dataModelListeners) {
                if (dataModelListener == null) continue;
                dataModelListener.rowSelected(dataModelEvent);
            }
        }
    }

    private static <E> List<E> iterableToList(Iterable<E> iterable) {
        ArrayList<E> list = null;
        if (iterable instanceof List) {
            list = (ArrayList<E>)iterable;
        } else if (iterable instanceof Collection) {
            list = new ArrayList((Collection)iterable);
        } else {
            list = new ArrayList<E>();
            Iterator<E> iterator = iterable.iterator();
            while (iterator.hasNext()) {
                list.add(iterator.next());
            }
        }
        return list;
    }
}

