/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.util;

import com.hazelcast.util.Clock;
import java.util.AbstractQueue;
import java.util.Collection;
import java.util.Iterator;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class ResponseQueueFactory {
    public static BlockingQueue newResponseQueue() {
        return new LockBasedResponseQueue();
    }

    private static final class LockBasedResponseQueue
    extends AbstractQueue
    implements BlockingQueue {
        private Object response = null;
        private final Lock lock = new ReentrantLock();
        private final Condition noValue = this.lock.newCondition();
        private static final Object NULL = new Object();

        private LockBasedResponseQueue() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object take() throws InterruptedException {
            this.lock.lock();
            try {
                while (this.response == null) {
                    this.noValue.await();
                }
                Object object = this.getAndRemoveResponse();
                Object var3_2 = null;
                this.lock.unlock();
                return object;
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                this.lock.unlock();
                throw throwable;
            }
        }

        public boolean offer(Object o, long timeout, TimeUnit unit) throws InterruptedException {
            return this.offer(o);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object poll(long timeout, TimeUnit unit) throws InterruptedException {
            if (timeout < 0L) {
                throw new IllegalArgumentException();
            }
            this.lock.lock();
            try {
                long start;
                for (long remaining = unit.toMillis(timeout); this.response == null && remaining > 0L; remaining -= Clock.currentTimeMillis() - start) {
                    start = Clock.currentTimeMillis();
                    this.noValue.await(remaining, TimeUnit.MILLISECONDS);
                }
                Object object = this.getAndRemoveResponse();
                Object var9_6 = null;
                this.lock.unlock();
                return object;
            }
            catch (Throwable throwable) {
                Object var9_7 = null;
                this.lock.unlock();
                throw throwable;
            }
        }

        public void put(Object o) throws InterruptedException {
            this.offer(o);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean offer(Object obj) {
            block4: {
                if (obj == null) {
                    obj = NULL;
                }
                this.lock.lock();
                try {
                    if (this.response == null) break block4;
                    boolean bl = false;
                    Object var4_4 = null;
                    this.lock.unlock();
                    return bl;
                }
                catch (Throwable throwable) {
                    Object var4_6 = null;
                    this.lock.unlock();
                    throw throwable;
                }
            }
            this.response = obj;
            this.noValue.signal();
            boolean bl = true;
            Object var4_5 = null;
            this.lock.unlock();
            return bl;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object poll() {
            this.lock.lock();
            try {
                Object object = this.getAndRemoveResponse();
                Object var3_2 = null;
                this.lock.unlock();
                return object;
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                this.lock.unlock();
                throw throwable;
            }
        }

        private Object getAndRemoveResponse() {
            Object value = this.response;
            this.response = null;
            return value == NULL ? null : value;
        }

        public int remainingCapacity() {
            throw new UnsupportedOperationException();
        }

        public int drainTo(Collection c) {
            throw new UnsupportedOperationException();
        }

        public int drainTo(Collection c, int maxElements) {
            throw new UnsupportedOperationException();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void clear() {
            this.lock.lock();
            try {
                this.response = null;
                Object var2_1 = null;
                this.lock.unlock();
            }
            catch (Throwable throwable) {
                Object var2_2 = null;
                this.lock.unlock();
                throw throwable;
            }
        }

        public Iterator iterator() {
            throw new UnsupportedOperationException();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int size() {
            this.lock.lock();
            try {
                int n = this.response == null ? 0 : 1;
                Object var3_2 = null;
                this.lock.unlock();
                return n;
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                this.lock.unlock();
                throw throwable;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object peek() {
            this.lock.lock();
            try {
                Object object = this.response;
                Object var3_2 = null;
                this.lock.unlock();
                return object;
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                this.lock.unlock();
                throw throwable;
            }
        }
    }
}

