/*
 * Decompiled with CFR 0.152.
 */
package br.com.dsfnet.gpd.fx.view;

import br.com.dsfnet.gpd.client.form.AplicacaoForm;
import br.com.dsfnet.gpd.client.form.DesenvolvimentoForm;
import br.com.dsfnet.gpd.fx.util.OrdenacaoLista;
import br.com.dsfnet.gpd.fx.view.BaseFxml;
import br.com.dsfnet.gpd.fx.view.MensagemView;
import br.com.jarch.svn.StatusArquivoForm;
import br.com.jarch.util.LogUtils;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.ResourceBundle;
import java.util.stream.Collectors;
import javafx.application.Platform;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.concurrent.Task;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.scene.control.Button;
import javafx.scene.control.ComboBox;
import javafx.scene.control.TabPane;
import javafx.scene.control.TableView;
import javafx.scene.control.TextArea;
import org.tmatesoft.svn.core.wc.SVNStatusType;

public class SalvamentoDesenvolvimentoController
extends BaseFxml {
    @FXML
    private Button buttonSalvaDesenvolvimento;
    @FXML
    private TextArea textAreaComentario;
    @FXML
    private ComboBox comboBoxDesenvolvimento;
    @FXML
    private TableView<StatusArquivoForm> tableViewArquivo;
    @FXML
    private TabPane tabPane;
    private ObservableList<DesenvolvimentoForm> dadosGrid;

    @Override
    public void initialize(URL url, ResourceBundle rb) {
        this.getDesenvolvimentoClientFachada().criaColunasTableViewArquivo(this.tableViewArquivo);
        this.comboBoxDesenvolvimento.setOnAction(event -> this.eventoCliqueSol());
        Platform.runLater(this::criaTaskAtualizacaoGrid);
    }

    public void buttonSalvaDesenvolvimentoAction(ActionEvent event) {
        Task<Void> task = new Task<Void>(){

            protected Void call() throws Exception {
                DesenvolvimentoForm desenvolvimentoForm = (DesenvolvimentoForm)SalvamentoDesenvolvimentoController.this.comboBoxDesenvolvimento.getSelectionModel().getSelectedItem();
                if (desenvolvimentoForm == null) {
                    throw new Exception("Selecione uma SOL");
                }
                if (desenvolvimentoForm == null) {
                    throw new Exception("Selecione uma SOL");
                }
                if (SalvamentoDesenvolvimentoController.this.textAreaComentario.getText().isEmpty()) {
                    throw new Exception("Coment\u00e1rio tem que conter pelo menos 5 caracteres");
                }
                SalvamentoDesenvolvimentoController.this.desabilitaComponentes();
                LogUtils.generate((String)("##### Selecionado " + desenvolvimentoForm.getBranch()));
                desenvolvimentoForm.setComentario(SalvamentoDesenvolvimentoController.this.textAreaComentario.getText());
                AplicacaoForm aplicacaoForm = SalvamentoDesenvolvimentoController.this.getConsumoRestSingleton().pesquisaAplicacao(desenvolvimentoForm.getCliente(), desenvolvimentoForm.getSistema(), desenvolvimentoForm.getTecnologia());
                SalvamentoDesenvolvimentoController.this.startProcessLog();
                SalvamentoDesenvolvimentoController.this.criaTaskAtualizacaoLabel();
                List<String> log = SalvamentoDesenvolvimentoController.this.getDesenvolvimentoClientFachada().salvaDesenvolvimento(SalvamentoDesenvolvimentoController.this.getConfiguracaoSingleton().getServidorSvn(), desenvolvimentoForm, aplicacaoForm, this.statusArquivo(), SalvamentoDesenvolvimentoController.this.getOutputStream());
                Platform.runLater(() -> SalvamentoDesenvolvimentoController.this.updateLogWebView(String.join((CharSequence)"\n", log)));
                return null;
            }

            protected void failed() {
                Platform.runLater(() -> {
                    SalvamentoDesenvolvimentoController.this.endProcessLog();
                    MensagemView.getInstancia().mostraErro(SalvamentoDesenvolvimentoController.this.anchorPane, this.getException().getMessage());
                    SalvamentoDesenvolvimentoController.this.habilitaComponentes();
                });
            }

            protected void succeeded() {
                Platform.runLater(() -> {
                    SalvamentoDesenvolvimentoController.this.endProcessLog();
                    MensagemView.getInstancia().mostraSucesso(SalvamentoDesenvolvimentoController.this.anchorPane, "Processamento Conclu\u00eddo com Sucesso");
                    SalvamentoDesenvolvimentoController.this.habilitaComponentes();
                });
            }

            private Collection<String> statusArquivo() {
                ArrayList<String> x = new ArrayList<String>();
                for (int i = 0; i < SalvamentoDesenvolvimentoController.this.tableViewArquivo.getItems().size(); ++i) {
                    StatusArquivoForm s = (StatusArquivoForm)SalvamentoDesenvolvimentoController.this.tableViewArquivo.getItems().get(i);
                    if (!s.isIgnora()) continue;
                    x.add(s.getArquivo());
                }
                return x;
            }
        };
        Thread t = new Thread((Runnable)task);
        t.setDaemon(true);
        t.start();
    }

    private void desabilitaComponentes() {
        this.habilitaDesabilitaComponente(true);
    }

    private void habilitaComponentes() {
        this.habilitaDesabilitaComponente(false);
    }

    private void habilitaDesabilitaComponente(boolean disable) {
        Platform.runLater(() -> {
            this.comboBoxDesenvolvimento.setDisable(disable);
            this.textAreaComentario.setDisable(disable);
            this.tabPane.setDisable(disable);
            this.buttonSalvaDesenvolvimento.setDisable(disable);
        });
    }

    public void criaTaskAtualizacaoGrid() {
        Task<Void> task = new Task<Void>(){

            protected Void call() throws Exception {
                try {
                    List<DesenvolvimentoForm> listaSolsAberto = SalvamentoDesenvolvimentoController.this.getConsumoRestSingleton().listaSolsDesenvolvimento();
                    SalvamentoDesenvolvimentoController.this.dadosGrid = FXCollections.observableArrayList(listaSolsAberto);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                return null;
            }

            protected void succeeded() {
                Platform.runLater(() -> SalvamentoDesenvolvimentoController.this.comboBoxDesenvolvimento.setItems(SalvamentoDesenvolvimentoController.this.dadosGrid));
            }

            protected void failed() {
                SalvamentoDesenvolvimentoController.this.comboBoxDesenvolvimento.setItems(null);
            }
        };
        Thread t = new Thread((Runnable)task);
        t.setDaemon(true);
        t.start();
    }

    private void eventoCliqueSol() {
        try {
            DesenvolvimentoForm desenvolvimentoForm = (DesenvolvimentoForm)this.comboBoxDesenvolvimento.getSelectionModel().getSelectedItem();
            if (desenvolvimentoForm == null) {
                return;
            }
            AplicacaoForm aplicacaoForm = this.getConsumoRestSingleton().pesquisaAplicacao(desenvolvimentoForm.getCliente(), desenvolvimentoForm.getSistema(), desenvolvimentoForm.getTecnologia());
            List<StatusArquivoForm> listaArquivoNaoComitado = this.getDesenvolvimentoClientFachada().listaArquivoNaoComitado(this.getConfiguracaoSingleton().getLogin(), this.getConfiguracaoSingleton().getSenha(), aplicacaoForm, desenvolvimentoForm.getBranch(), this.getOutputStream());
            ObservableList data = FXCollections.observableArrayList(listaArquivoNaoComitado);
            Platform.runLater(() -> this.tableViewArquivo.setItems(data));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void eventoCliqueArquivo() {
        try {
            int selecionado = this.tableViewArquivo.getSelectionModel().getSelectedIndex();
            if (selecionado < 0) {
                return;
            }
            StatusArquivoForm statusArquivoForm = (StatusArquivoForm)this.tableViewArquivo.getItems().get(selecionado);
            if (statusArquivoForm.getStatus().equals(SVNStatusType.STATUS_MODIFIED.toString().toUpperCase())) {
                this.updateLogWebView(String.join((CharSequence)"\n", this.getDesenvolvimentoClientFachada().diferencaArquivo(this.getConfiguracaoSingleton().getLogin(), this.getConfiguracaoSingleton().getSenha(), statusArquivoForm.getArquivo(), this.getOutputStream())));
            } else {
                this.updateLogWebView("Arquivo com " + statusArquivoForm.getArquivo() + " com " + statusArquivoForm.getStatus() + " n\u00e3o pode ser comparado");
            }
            this.tabPane.getSelectionModel().select(1);
            this.textAreaLog.requestFocus();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void atualizaGrid() {
        try {
            List<DesenvolvimentoForm> listaSolsAberto = this.getConsumoRestSingleton().listaSolsDesenvolvimento();
            ObservableList data = FXCollections.observableArrayList(listaSolsAberto);
            Platform.runLater(() -> {
                this.comboBoxDesenvolvimento.getItems().clear();
                this.comboBoxDesenvolvimento.getItems().addAll((Collection)data.stream().sorted(OrdenacaoLista.desenvolvimentoFormComparator).collect(Collectors.toList()));
                this.comboBoxDesenvolvimento.getSelectionModel().select(-1);
            });
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

