/*
 * Decompiled with CFR 0.152.
 */
package br.com.dsfnet.gpd.fx.view;

import br.com.dsfnet.gpd.client.PublicacaoDomain;
import br.com.dsfnet.gpd.client.form.PublicacaoForm;
import br.com.dsfnet.gpd.client.sistema.AmbienteType;
import br.com.dsfnet.gpd.client.sistema.LocalType;
import br.com.dsfnet.gpd.client.sistema.ModuloType;
import br.com.dsfnet.gpd.client.sistema.SistemaEntity;
import br.com.dsfnet.gpd.client.util.Utils;
import br.com.dsfnet.gpd.fx.util.RemoteFactory;
import br.com.dsfnet.gpd.fx.view.BaseFxml;
import br.com.dsfnet.gpd.fx.view.MensagemView;
import br.com.jarch.util.SleepUtils;
import de.jensd.fx.glyphs.fontawesome.FontAwesomeIconView;
import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.stream.Collectors;
import javafx.application.Platform;
import javafx.concurrent.Task;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.control.RadioButton;
import javafx.scene.control.TextField;
import javafx.scene.input.Clipboard;
import javafx.scene.input.ClipboardContent;
import org.controlsfx.control.CheckComboBox;

public class PublicacaoController
extends BaseFxml {
    private static final String SSH_REMOTE_USER = "wagner.araujo";
    private static final String SSH_REMOTE_PASSWORD = "J2s5s_Cr3st4@";
    @FXML
    private RadioButton radioButtonTask;
    @FXML
    private RadioButton radioButtonPacote;
    @FXML
    private RadioButton radioButtonTrunk;
    @FXML
    private ComboBox<SistemaEntity> comboBoxAplicacao;
    @FXML
    private Button buttonInicioPublicacao;
    @FXML
    private CheckComboBox<LocalType> choiceBoxLocal;
    @FXML
    private CheckComboBox<AmbienteType> choiceBoxAmbiente;
    @FXML
    private CheckComboBox<ModuloType> choiceBoxModulo;
    @FXML
    private FontAwesomeIconView iconLabelTaskPacote;
    @FXML
    private Label labelTaskPacote;
    @FXML
    private TextField textFieldTaskPacote;
    @FXML
    private TextField textFieldNomeAlternativo;
    @FXML
    private CheckBox checkBoxMostraComandoSql;
    private PublicacaoDomain publicacaoDomain;

    @Override
    public void initialize(URL url, ResourceBundle rb) {
        this.publicacaoDomain = new PublicacaoDomain(this.getConfiguracaoSingleton().getServidorSvn(), this.getConfiguracaoSingleton().getLogin(), this.getConfiguracaoSingleton().getSenha(), this.getConfiguracaoSingleton().getLoginSshLocal(), this.getConfiguracaoSingleton().getPasswordSshLocal(), SSH_REMOTE_USER, SSH_REMOTE_PASSWORD, this.getOutputStream());
        this.configuraTextFieldBranch();
        this.configuraOnShow();
        this.configuraInicial();
        this.clearLog();
    }

    private void configuraTextFieldBranch() {
        this.textFieldTaskPacote.textProperty().addListener((observable, oldValue, newValue) -> {
            String value = Utils.extraiNumeroJira((String)newValue);
            this.textFieldTaskPacote.setText(value);
        });
    }

    private void limpaComponentes() {
        this.comboBoxAplicacao.getSelectionModel().clearSelection();
        this.radioButtonTask.setSelected(false);
        this.radioButtonPacote.setSelected(false);
        this.radioButtonTrunk.setSelected(false);
        this.textFieldTaskPacote.clear();
        this.textFieldNomeAlternativo.clear();
        this.checkBoxMostraComandoSql.setSelected(false);
        this.atualizaComboLocal();
        this.atualizaComboAmbiente();
        this.atualizaComboLocalAmbienteModulo();
    }

    private void configuraRadioButtonTipo() {
        EventHandler handler = e -> this.updateTaskPacoteVisibilityAndLabel();
        this.radioButtonTask.setOnAction(handler);
        this.radioButtonPacote.setOnAction(handler);
        this.radioButtonTrunk.setOnAction(handler);
    }

    private void updateTaskPacoteVisibilityAndLabel() {
        boolean isVisible = !this.radioButtonTrunk.isSelected();
        this.iconLabelTaskPacote.setVisible(isVisible);
        this.labelTaskPacote.setVisible(isVisible);
        this.textFieldTaskPacote.setVisible(isVisible);
        this.labelTaskPacote.setText(this.radioButtonTask.isSelected() ? "Task" : "Pacote");
        if (this.radioButtonTrunk.isSelected()) {
            this.textFieldTaskPacote.clear();
        } else {
            this.textFieldTaskPacote.requestFocus();
        }
    }

    private void configuraOnShow() {
        Platform.runLater(this::configuraInicial);
    }

    private void configuraInicial() {
        this.habilitaComponentes();
        this.limpaComponentes();
        this.configuraComboAplicacao();
        this.configuraRadioButtonTipo();
    }

    public void buttonIniciarPublicacaoAction(ActionEvent ignoredEvent) {
        Task<Void> task = new Task<Void>(){

            protected Void call() throws Exception {
                PublicacaoController.this.validaPreenchimentoCampos();
                PublicacaoController.this.desabilitaComponentes();
                Platform.runLater(() -> PublicacaoController.this.clearLog());
                PublicacaoController.this.startProcessLog();
                PublicacaoController.this.criaTaskAtualizacaoLabel();
                SistemaEntity aplicacao = (SistemaEntity)PublicacaoController.this.comboBoxAplicacao.getSelectionModel().getSelectedItem();
                PublicacaoController.this.publicacaoDomain.versaoJava(aplicacao.getVersaoJava()).projetoSvn(aplicacao.getProjetoSvn()).locais(PublicacaoController.this.getLocaisSelecionados()).ambientes(PublicacaoController.this.getAmbientesSelecionados()).modulos(PublicacaoController.this.getModulosSelecionados()).trunk(PublicacaoController.this.radioButtonTrunk.isSelected()).branchPacote(PublicacaoController.this.textFieldTaskPacote.getText()).mostraComandoSql(PublicacaoController.this.checkBoxMostraComandoSql.isSelected()).nomeAlternativo(PublicacaoController.this.textFieldNomeAlternativo.getText()).publicaAplicacao();
                return null;
            }

            protected void failed() {
                Platform.runLater(() -> {
                    SleepUtils.pauseSeconds((int)1);
                    String mensagemErro = this.exceptionNow().getMessage();
                    mensagemErro = mensagemErro == null ? "" : mensagemErro.trim();
                    mensagemErro = mensagemErro.replace("java.lang.RuntimeException: ", "");
                    PublicacaoController.this.appendLog("\n\n" + String.join((CharSequence)"\n", mensagemErro));
                    PublicacaoController.this.endProcessLog();
                    MensagemView.getInstancia().mostraErro(PublicacaoController.this.anchorPane, mensagemErro);
                    PublicacaoController.this.habilitaComponentes();
                });
            }

            protected void succeeded() {
                Platform.runLater(() -> {
                    PublicacaoController.this.endProcessLog();
                    StringBuilder logMessages = PublicacaoController.this.publicacaoDomain.getLogMessages();
                    List logPublicacaoOk = Arrays.stream(logMessages.toString().split("\n")).collect(Collectors.toList());
                    logPublicacaoOk.removeIf(l -> !l.startsWith("###") && !l.startsWith("- "));
                    String logCopiaColaJira = String.valueOf(logMessages) + "\n\n >>>>> COPIE O LOG ABAIXO E COLE NA TASK DO JIRA <<<<<\n\n" + String.join((CharSequence)"\n", logPublicacaoOk);
                    PublicacaoController.this.appendLog(logCopiaColaJira);
                    ClipboardContent clipboardContent = new ClipboardContent();
                    clipboardContent.putString(String.join((CharSequence)"\n", logPublicacaoOk));
                    Clipboard.getSystemClipboard().setContent((Map)clipboardContent);
                    MensagemView.getInstancia().mostraSucesso(PublicacaoController.this.anchorPane, "Processamento Conclu\u00eddo com Sucesso");
                    PublicacaoController.this.habilitaComponentes();
                    PublicacaoController.this.limpaComponentes();
                });
            }
        };
        new Thread((Runnable)task).start();
    }

    private void validaPreenchimentoCampos() throws Exception {
        if (this.comboBoxAplicacao.getSelectionModel().isEmpty()) {
            throw new Exception("Aplica\u00e7\u00e3o N\u00c3O Selecionada !");
        }
        if (!(this.radioButtonTask.isSelected() || this.radioButtonPacote.isSelected() || this.radioButtonTrunk.isSelected())) {
            throw new Exception("Tipo N\u00c3O Selecionado !");
        }
        if (!this.radioButtonTrunk.isSelected() && this.textFieldTaskPacote.getText().isBlank()) {
            throw new Exception((this.radioButtonTask.isSelected() ? "Task" : "Pacote") + " N\u00c3O Informado !");
        }
        if (this.choiceBoxLocal.getCheckModel().isEmpty()) {
            throw new Exception("Local(is) N\u00c3O Informado !");
        }
        if (this.choiceBoxAmbiente.getCheckModel().isEmpty()) {
            throw new Exception("Ambiente(s) N\u00c3O Informado !");
        }
        if (this.choiceBoxModulo.getCheckModel().isEmpty()) {
            throw new Exception("Modulo(s) N\u00c3O Informado !");
        }
    }

    private void desabilitaComponentes() {
        this.habilitaDesabilitaComponente(true);
    }

    private void habilitaComponentes() {
        this.habilitaDesabilitaComponente(false);
    }

    private void habilitaDesabilitaComponente(boolean disable) {
        Platform.runLater(() -> {
            this.comboBoxAplicacao.setDisable(disable);
            this.radioButtonTask.setDisable(disable);
            this.radioButtonPacote.setDisable(disable);
            this.radioButtonTrunk.setDisable(disable);
            this.textFieldTaskPacote.setDisable(disable);
            this.choiceBoxLocal.setDisable(disable);
            this.choiceBoxAmbiente.setDisable(disable);
            this.choiceBoxModulo.setDisable(disable);
            if (this.getConfiguracaoSingleton().getLogin().contains(".araujo")) {
                this.textFieldNomeAlternativo.setDisable(disable);
                this.checkBoxMostraComandoSql.setDisable(disable);
            } else {
                this.textFieldNomeAlternativo.setDisable(true);
                this.checkBoxMostraComandoSql.setDisable(true);
            }
            this.buttonInicioPublicacao.setDisable(disable);
        });
    }

    private void configuraComboAplicacao() {
        this.comboBoxAplicacao.getSelectionModel().clearSelection();
        this.comboBoxAplicacao.getItems().clear();
        List<SistemaEntity> aplicacoes = RemoteFactory.getInstance().getProcessamento().aplicacoesPublicaveis().stream().sorted(Comparator.comparing(SistemaEntity::getSistema)).toList();
        this.comboBoxAplicacao.getItems().addAll(aplicacoes);
        this.comboBoxAplicacao.setValue(null);
        this.comboBoxAplicacao.setOnAction(me -> this.atualizaComboLocalAmbienteModulo());
    }

    public void atualizaComboLocalAmbienteModulo() {
        this.geraListaPublicacoes();
        this.atualizaComboLocal();
        this.atualizaComboAmbiente();
        this.atualizaComboModulo();
    }

    private void atualizaComboLocal() {
        this.choiceBoxLocal.getCheckModel().clearChecks();
        this.choiceBoxLocal.getItems().clear();
        List locais = this.publicacaoDomain.getLocais();
        this.choiceBoxLocal.getItems().addAll((Collection)locais);
    }

    private void atualizaComboAmbiente() {
        this.choiceBoxAmbiente.getCheckModel().clearChecks();
        this.choiceBoxAmbiente.getItems().clear();
        List ambientes = this.publicacaoDomain.getAmbientes();
        this.choiceBoxAmbiente.getItems().addAll((Collection)ambientes);
    }

    private void atualizaComboModulo() {
        this.choiceBoxModulo.getCheckModel().clearChecks();
        this.choiceBoxModulo.getItems().clear();
        List modulos = this.publicacaoDomain.getModulos();
        this.choiceBoxModulo.getItems().addAll((Collection)modulos);
    }

    private void geraListaPublicacoes() {
        SistemaEntity aplicacao = (SistemaEntity)this.comboBoxAplicacao.getSelectionModel().getSelectedItem();
        if (aplicacao == null || aplicacao.getListaDadosPublicacao() == null) {
            this.publicacaoDomain.setPublicacoesSistema(List.of());
            return;
        }
        List publicacoesSistema = aplicacao.getListaDadosPublicacao().stream().map(PublicacaoForm::new).collect(Collectors.toList());
        this.publicacaoDomain.setPublicacoesSistema(publicacoesSistema);
    }

    private List<ModuloType> getModulosSelecionados() {
        List modulosSelecionados = this.choiceBoxModulo.getCheckModel().getCheckedItems().stream().toList();
        return this.publicacaoDomain.getPublicacoesSistema().stream().filter(p -> modulosSelecionados.contains(p.getModulo())).sorted(Comparator.comparing(PublicacaoForm::getComandoAntesCompilacao).reversed()).map(PublicacaoForm::getModulo).distinct().toList();
    }

    private List<AmbienteType> getAmbientesSelecionados() {
        return this.choiceBoxAmbiente.getCheckModel().getCheckedItems().stream().toList();
    }

    private List<LocalType> getLocaisSelecionados() {
        return this.choiceBoxLocal.getCheckModel().getCheckedItems().stream().toList();
    }
}

