/*
 * Decompiled with CFR 0.152.
 */
package br.com.dsfnet.gpd.fx.view;

import br.com.jarch.util.LogUtils;
import javafx.application.Platform;
import javafx.event.EventHandler;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.effect.Effect;
import javafx.scene.effect.InnerShadow;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.Pane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.paint.RadialGradient;
import javafx.scene.shape.Rectangle;
import javafx.scene.text.Font;
import javafx.stage.Screen;

public class MensagemView {
    private static MensagemView instancia;
    Label lblTitulo;
    Label lblMensagem;
    Button btnSair;
    Pane pane;
    Rectangle rectangle;
    RadialGradient radialGradient;
    AnchorPane anchorPane;
    Runnable callBack;

    public static MensagemView getInstancia() {
        if (instancia == null) {
            instancia = new MensagemView();
        }
        return instancia;
    }

    private MensagemView() {
        Font fntMensagem = new Font("Segoe UI", 15.0);
        Font fntTitulo = new Font("Segoe UI", 24.0);
        this.lblTitulo = new Label();
        this.lblTitulo.setFont(fntTitulo);
        this.lblTitulo.setTextFill((Paint)Color.WHITE);
        this.lblTitulo.setLayoutX(0.0);
        this.lblTitulo.setLayoutY(10.0);
        this.lblTitulo.setPrefSize(600.0, 50.0);
        this.lblTitulo.setAlignment(Pos.CENTER);
        this.lblMensagem = new Label();
        this.lblMensagem.setFont(fntMensagem);
        this.lblMensagem.setTextFill((Paint)Color.web((String)"#333333"));
        this.lblMensagem.setLayoutX(20.0);
        this.lblMensagem.setLayoutY(70.0);
        this.lblMensagem.setPrefSize(580.0, 80.0);
        this.lblMensagem.setWrapText(true);
        this.lblMensagem.setAlignment(Pos.CENTER);
        InnerShadow innerShadow = new InnerShadow();
        innerShadow.setColor(Color.rgb((int)0, (int)0, (int)0, (double)0.3));
        innerShadow.setRadius(5.0);
        EventHandler onMouseEnter = mouseEvent -> ((Node)mouseEvent.getSource()).setEffect((Effect)innerShadow);
        EventHandler onMouseExit = mouseEvent -> ((Node)mouseEvent.getSource()).setEffect(null);
        this.btnSair = new Button("OK");
        this.btnSair.setPrefSize(120.0, 35.0);
        this.btnSair.setLayoutX(240.0);
        this.btnSair.setLayoutY(150.0);
        this.btnSair.setFont(new Font("Segoe UI", 14.0));
        this.btnSair.setOnMouseEntered(onMouseEnter);
        this.btnSair.setOnMouseExited(onMouseExit);
        this.btnSair.setOnMouseClicked(me -> this.sair());
        this.pane = new Pane();
        this.pane.setOpacity(1.0);
        this.rectangle = new Rectangle();
        this.rectangle.setArcWidth(20.0);
        this.rectangle.setArcHeight(20.0);
        this.rectangle.setWidth(600.0);
        this.rectangle.setHeight(200.0);
        this.rectangle.setFill((Paint)Color.WHITE);
        this.rectangle.setStroke((Paint)Color.web((String)"#e0e0e0"));
        this.rectangle.setStrokeWidth(1.0);
        InnerShadow shadow = new InnerShadow();
        shadow.setOffsetX(0.0);
        shadow.setOffsetY(0.0);
        shadow.setRadius(5.0);
        shadow.setColor(Color.rgb((int)0, (int)0, (int)0, (double)0.1));
        this.rectangle.setEffect((Effect)shadow);
        Rectangle headerRect = new Rectangle();
        headerRect.setWidth(600.0);
        headerRect.setHeight(60.0);
        headerRect.setArcWidth(20.0);
        headerRect.setArcHeight(20.0);
        headerRect.setFill((Paint)Color.web((String)"#2C3E50"));
        Rectangle headerClip = new Rectangle();
        headerClip.setWidth(600.0);
        headerClip.setHeight(60.0);
        headerClip.setArcWidth(20.0);
        headerClip.setArcHeight(20.0);
        headerRect.setClip((Node)headerClip);
        this.pane.setPrefSize(600.0, 200.0);
        this.pane.getChildren().addAll((Object[])new Node[]{this.rectangle, headerRect, this.lblTitulo, this.lblMensagem, this.btnSair});
    }

    private void centralizaPanel() {
        double screenHeight;
        double screenWidth;
        if (this.anchorPane == null) {
            screenWidth = Screen.getPrimary().getVisualBounds().getWidth();
            screenHeight = Screen.getPrimary().getVisualBounds().getHeight();
        } else {
            screenWidth = this.anchorPane.getWidth();
            screenHeight = this.anchorPane.getHeight();
        }
        this.pane.setLayoutX((screenWidth - 600.0) / 2.0);
        this.pane.setLayoutY((screenHeight - 200.0) / 2.0);
    }

    public void mostraSucesso(AnchorPane anchorPane, String mensagem) {
        this.centralizaPanel();
        this.btnSair.setStyle("-fx-background-color: #2ecc71; -fx-text-fill: white; -fx-background-radius: 5px;");
        Rectangle headerRect = (Rectangle)this.pane.getChildren().get(1);
        headerRect.setFill((Paint)Color.web((String)"#2C3E50"));
        this.anchorPane = anchorPane;
        this.lblTitulo.setText("AVISO");
        this.lblMensagem.setText(mensagem);
        if (!anchorPane.getChildren().contains((Object)this.pane)) {
            try {
                Platform.runLater(() -> anchorPane.getChildren().add((Object)this.pane));
            }
            catch (Exception ex) {
                LogUtils.generate((Throwable)ex);
            }
        }
    }

    public void mostraErro(AnchorPane anchorPane, String mensagem) {
        this.mostraErro(anchorPane, mensagem, null);
    }

    public void mostraErro(AnchorPane anchorPane, String mensagem, Runnable callBack) {
        this.centralizaPanel();
        this.callBack = callBack;
        this.btnSair.setStyle("-fx-background-color: #e74c3c; -fx-text-fill: white; -fx-background-radius: 5px;");
        Rectangle headerRect = (Rectangle)this.pane.getChildren().get(1);
        headerRect.setFill((Paint)Color.web((String)"#c0392b"));
        this.anchorPane = anchorPane;
        this.lblTitulo.setText("ATEN\u00c7\u00c3O");
        this.lblMensagem.setText(mensagem);
        if (!anchorPane.getChildren().contains((Object)this.pane)) {
            try {
                anchorPane.getChildren().add((Object)this.pane);
            }
            catch (Exception ex) {
                LogUtils.generate((Throwable)ex);
            }
        }
    }

    private void sair() {
        this.anchorPane.getChildren().remove((Object)this.pane);
        if (this.callBack != null) {
            this.callBack.run();
        }
    }
}

