/*
 * Decompiled with CFR 0.152.
 */
package br.com.dsfnet.gpd.fx.view;

import br.com.dsfnet.gpd.client.exception.EmpacotamentoException;
import br.com.dsfnet.gpd.client.planejamento.PlanejamentoEntity;
import br.com.dsfnet.gpd.fx.util.AnalisaIdeDesenvolvimento;
import br.com.dsfnet.gpd.fx.util.OrdenacaoLista;
import br.com.dsfnet.gpd.fx.util.RemoteFactory;
import br.com.dsfnet.gpd.fx.view.BaseFxml;
import br.com.dsfnet.gpd.fx.view.MensagemView;
import br.com.jarch.util.LogUtils;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.stream.Collectors;
import javafx.application.Platform;
import javafx.concurrent.Task;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.scene.control.Button;
import javafx.scene.control.ComboBox;

public class CriacaoEmpacotamentoController
extends BaseFxml {
    @FXML
    private ComboBox comboBoxPlanejamento;
    @FXML
    private Button buttonInicioDesenvolvimento;

    @Override
    public void initialize(URL url, ResourceBundle rb) {
        this.atualizaCombo();
        Platform.runLater(() -> {
            try {
                this.atualizaCombo();
                this.clearLog();
            }
            catch (Exception ex) {
                LogUtils.generate((Throwable)ex);
            }
        });
    }

    public void buttonIniciarDesenvolvimentoAction(ActionEvent event) {
        Task<Void> task = new Task<Void>(){

            protected Void call() throws Exception {
                CriacaoEmpacotamentoController.this.desabilitaComponentes();
                PlanejamentoEntity planejamento = (PlanejamentoEntity)CriacaoEmpacotamentoController.this.comboBoxPlanejamento.getSelectionModel().getSelectedItem();
                if (planejamento == null) {
                    throw new EmpacotamentoException("Selecione o planejamento");
                }
                RemoteFactory.getInstance().getProcessamento().validacaoCriacaoEmpacotamento(planejamento.getId(), CriacaoEmpacotamentoController.this.getConfiguracaoSingleton().getLogin());
                AnalisaIdeDesenvolvimento.existeAlgumaEmExecucao();
                CriacaoEmpacotamentoController.this.startProcessLog();
                Platform.runLater(() -> CriacaoEmpacotamentoController.this.clearLog());
                CriacaoEmpacotamentoController.this.criaTaskAtualizacaoLabel();
                ArrayList log = new ArrayList();
                CriacaoEmpacotamentoController.this.getEmpacotamentoSvn().criacaoEmpacotamento(CriacaoEmpacotamentoController.this.getConfiguracaoSingleton().getServidorSvn(), CriacaoEmpacotamentoController.this.getConfiguracaoSingleton().getLogin(), CriacaoEmpacotamentoController.this.getConfiguracaoSingleton().getSenha(), planejamento, log, CriacaoEmpacotamentoController.this.getOutputStream());
                RemoteFactory.getInstance().getProcessamento().atualizacaoBancoDadosCriacaoEmpacotamento(CriacaoEmpacotamentoController.this.getConfiguracaoSingleton().getLogin(), planejamento.getId());
                return null;
            }

            protected void failed() {
                this.getException().printStackTrace();
                Platform.runLater(() -> {
                    CriacaoEmpacotamentoController.this.endProcessLog();
                    MensagemView.getInstancia().mostraErro(CriacaoEmpacotamentoController.this.anchorPane, this.getException().getMessage());
                    CriacaoEmpacotamentoController.this.habilitaComponentes();
                });
            }

            protected void succeeded() {
                Platform.runLater(() -> {
                    CriacaoEmpacotamentoController.this.endProcessLog();
                    MensagemView.getInstancia().mostraSucesso(CriacaoEmpacotamentoController.this.anchorPane, "Processamento Conclu\u00eddo com Sucesso");
                    CriacaoEmpacotamentoController.this.habilitaComponentes();
                    CriacaoEmpacotamentoController.this.atualizaCombo();
                });
            }
        };
        new Thread((Runnable)task).start();
    }

    private void desabilitaComponentes() {
        this.habilitaDesabilitaComponente(true);
    }

    private void habilitaComponentes() {
        this.habilitaDesabilitaComponente(false);
    }

    private void habilitaDesabilitaComponente(boolean disable) {
        Platform.runLater(() -> {
            this.comboBoxPlanejamento.setDisable(disable);
            this.buttonInicioDesenvolvimento.setDisable(disable);
        });
    }

    private void atualizaCombo() {
        this.comboBoxPlanejamento.getSelectionModel().clearSelection();
        this.comboBoxPlanejamento.getItems().clear();
        Set listaPacotes = RemoteFactory.getInstance().getProcessamento().listaPlanejamento();
        if (listaPacotes.size() > 0) {
            this.comboBoxPlanejamento.getItems().addAll((Collection)listaPacotes.stream().sorted(OrdenacaoLista.planejamentoComparator).collect(Collectors.toList()));
        }
        this.comboBoxPlanejamento.setValue(null);
    }
}

