/*
 * Decompiled with CFR 0.152.
 */
package br.com.dsfnet.gpd.fx.view;

import br.com.dsfnet.gpd.client.util.VariavelAmbiente;
import br.com.dsfnet.gpd.fx.util.ConfiguracaoSingleton;
import br.com.dsfnet.gpd.fx.util.ConsumoRestSingleton;
import br.com.dsfnet.gpd.fx.view.SplashController;
import br.com.jarch.util.LogUtils;
import jakarta.inject.Inject;
import java.io.IOException;
import java.util.Map;
import javafx.application.Application;
import javafx.application.Platform;

public class Aplicacao {
    public static final String LOCAL = "local";
    private static final String DSF_SP = "16NZ39BCtuoiCpquocTDJ2+Flyg2YBVd5pMSfn/cDisb0DkxhDZohg==";
    private static final String DSF_CG = "nmis9sN0X+XIbnfquKm2wKQCkK4ZxcfhhVPZK3AEMTvZ/jhtc8zBqw==";
    private static Aplicacao instancia;
    private Map<String, String> parametros;
    private SplashController splashView;
    private ConsumoRestSingleton consumoRestSingleton;
    private ConfiguracaoSingleton configuracaoSingleton;

    @Inject
    public Aplicacao(SplashController splashView, ConsumoRestSingleton consumoRestSingleton, ConfiguracaoSingleton configuracaoSingleton) {
        this.splashView = splashView;
        this.consumoRestSingleton = consumoRestSingleton;
        this.configuracaoSingleton = configuracaoSingleton;
    }

    public synchronized void start(Application.Parameters parameters) throws IOException {
        LogUtils.generate((String)VariavelAmbiente.getInterno());
        instancia = this;
        this.parametros = parameters.getNamed();
        this.configuraSingleton();
        this.splashView.mostraTela(null);
    }

    public static Aplicacao getInstancia() {
        return instancia;
    }

    public void encerrar() {
        Platform.exit();
    }

    private void configuraSingleton() {
        if (DSF_SP.equals(this.parametros.get(LOCAL))) {
            this.configuracaoSingleton.localDsfSp();
        } else if (DSF_CG.equals(this.parametros.get(LOCAL))) {
            this.configuracaoSingleton.localDsfSp();
        } else {
            this.configuracaoSingleton.localNaoIdentificado();
        }
        this.configuracaoSingleton.setAmbienteDebug("S".equals(this.parametros.get("debug")));
        this.configuracaoSingleton.setLoginSshLocal(this.parametros.get("loginSshLocal"));
        this.configuracaoSingleton.setPasswordSshLocal(this.parametros.get("passwordSshLocal"));
        this.consumoRestSingleton.carregaVariaveis();
        LogUtils.generate((String)("############# SVN: " + this.configuracaoSingleton.getServidorSvn()));
        LogUtils.generate((String)("UTILIZADOR: " + this.configuracaoSingleton.getUtilizador().name()));
    }

    public String getParametroExterno(String chave) {
        if (this.parametros == null) {
            return "";
        }
        String retorno = this.parametros.get(chave);
        if (retorno == null) {
            return "";
        }
        return retorno;
    }
}

