/*
 * Decompiled with CFR 0.152.
 */
package br.com.dsfnet.gpd.client.util;

import br.com.dsfnet.gpd.client.util.VariavelAmbiente;
import br.com.jarch.core.util.HashTagUtils;
import br.com.jarch.util.DateUtils;
import br.com.jarch.util.NumberUtils;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.time.LocalDateTime;
import java.util.HashMap;

public class PastaUtil {
    public static void remover(File f) throws Exception {
        if (f.isDirectory()) {
            File[] files;
            for (File file : files = f.listFiles()) {
                PastaUtil.remover(file);
            }
        }
        if (!f.delete()) {
            throw new Exception("Erro na tentativa de apagar " + f.getAbsolutePath());
        }
    }

    public static URL getUrlTrunk(String servidorSvn, String projetoSvn) throws MalformedURLException {
        Object urlTrunk = servidorSvn;
        if (!servidorSvn.endsWith("/") && !projetoSvn.startsWith("/")) {
            urlTrunk = servidorSvn.concat("/");
        }
        urlTrunk = (String)urlTrunk + projetoSvn + "/";
        urlTrunk = (String)urlTrunk + "trunk/";
        urlTrunk = PastaUtil.tratamento((String)urlTrunk);
        return new URL((String)urlTrunk);
    }

    public static URL getUrlBranch(String servidorSvn, String projetoSvn) throws MalformedURLException {
        return PastaUtil.getUrlBranch(servidorSvn, projetoSvn, null);
    }

    public static URL getUrlBranch(String servidorSvn, String projetoSvn, String branch) throws MalformedURLException {
        Object urlBranch = servidorSvn;
        if (!servidorSvn.endsWith("/") && !projetoSvn.startsWith("/")) {
            urlBranch = servidorSvn.concat("/");
        }
        urlBranch = (String)urlBranch + projetoSvn + "/";
        urlBranch = (String)urlBranch + "branches/";
        urlBranch = (String)urlBranch + branch;
        urlBranch = PastaUtil.tratamento((String)urlBranch);
        return new URL((String)urlBranch);
    }

    public static URL getUrlTag(String servidorSvn, String projetoSvn) throws MalformedURLException {
        return PastaUtil.getUrlTag(servidorSvn, projetoSvn, null);
    }

    public static URL getUrlTag(String servidorSvn, String projetoSvn, String tag) throws MalformedURLException {
        Object urlTag = servidorSvn;
        if (!servidorSvn.endsWith("/") && !projetoSvn.startsWith("/")) {
            urlTag = servidorSvn.concat("/");
        }
        urlTag = (String)urlTag + projetoSvn + "/";
        urlTag = (String)urlTag + "tags/";
        urlTag = (String)urlTag + tag;
        urlTag = PastaUtil.tratamento((String)urlTag);
        return new URL((String)urlTag);
    }

    public static File getPastaTrunk(String login, String raiz) throws Exception {
        return PastaUtil.getPasta(login, raiz + "/trunk/");
    }

    public static File getPastaBranch(String login, String raiz, String versao) throws Exception {
        return PastaUtil.getPasta(login, raiz + "/branches/" + versao + "/");
    }

    public static File getPastaTag(String login, String raiz, String versao) throws Exception {
        return PastaUtil.getPasta(login, raiz + "/tag/" + versao + "/");
    }

    public static File getPastaTrabalhoFinalizado(String login, String raiz, String branch) throws Exception {
        String pastaBackup = ".concluido" + File.separator + NumberUtils.onlyNumber((String)DateUtils.formatyyyyMMddHHmmss((LocalDateTime)LocalDateTime.now())) + "_" + branch + "_finalizado";
        String pastaBranch = PastaUtil.getPastaTrabalho(login, raiz, branch).getAbsolutePath();
        String pastaNova = pastaBranch.replace(branch, pastaBackup);
        return new File(pastaNova);
    }

    public static File getPastaTrabalhoDescartado(String login, String raiz, String branch) throws Exception {
        String pastaBackup = ".concluido" + File.separator + NumberUtils.onlyNumber((String)DateUtils.formatyyyyMMddHHmmss((LocalDateTime)LocalDateTime.now())) + "_" + branch + "_descartado";
        String pastaBranch = PastaUtil.getPastaTrabalho(login, raiz, branch).getAbsolutePath();
        String pastaNova = pastaBranch.replace(branch, pastaBackup);
        return new File(pastaNova);
    }

    public static File getPastaTrabalho(String login, String raiz, String branch) throws Exception {
        HashMap<String, String> mapaHashTag = new HashMap<String, String>();
        mapaHashTag.put("pastaProgramador", login);
        mapaHashTag.put("interno", VariavelAmbiente.getInterno());
        mapaHashTag.put("roboPublicador", VariavelAmbiente.getRoboPublicador());
        Object pasta = HashTagUtils.replaceHashTag((String)raiz, mapaHashTag);
        pasta = (String)pasta + File.separator + branch;
        pasta = PastaUtil.tratamento((String)pasta);
        return new File((String)pasta);
    }

    public static File getPastaPontoSvn(String login, String raiz) throws Exception {
        HashMap<String, String> mapaHashTag = new HashMap<String, String>();
        mapaHashTag.put("pastaProgramador", login);
        mapaHashTag.put("interno", VariavelAmbiente.getInterno());
        mapaHashTag.put("roboPublicador", VariavelAmbiente.getRoboPublicador());
        String pasta = HashTagUtils.replaceHashTag((String)raiz, mapaHashTag);
        pasta = PastaUtil.tratamento(pasta + "/.svn/");
        return new File(pasta);
    }

    private static File getPasta(String login, String raiz) throws Exception {
        HashMap<String, String> mapaHashTag = new HashMap<String, String>();
        mapaHashTag.put("pastaProgramador", login);
        mapaHashTag.put("interno", VariavelAmbiente.getInterno());
        mapaHashTag.put("roboPublicador", VariavelAmbiente.getRoboPublicador());
        String pasta = HashTagUtils.replaceHashTag((String)raiz, mapaHashTag);
        pasta = PastaUtil.tratamento(pasta);
        return new File(pasta);
    }

    private static String tratamento(String caminho) {
        caminho = ((String)caminho).trim();
        caminho = ((String)caminho).replace("//", "/");
        if (!((String)(caminho = ((String)caminho).replace(":/", "://"))).endsWith("/")) {
            caminho = (String)caminho + "/";
        }
        return caminho;
    }

    public static void moveBackupToConcluido(String baseDir) {
        File baseDirFile = new File(baseDir);
        if (!baseDirFile.exists() || !baseDirFile.isDirectory()) {
            System.out.println("O diret\u00f3rio base n\u00e3o existe ou n\u00e3o \u00e9 um diret\u00f3rio v\u00e1lido.");
            return;
        }
        File targetDirUnderlineConcluido = new File(baseDirFile, "_concluido");
        File targetDirDotConcluido = new File(baseDirFile, ".concluido");
        if (targetDirUnderlineConcluido.exists() && !targetDirDotConcluido.exists()) {
            try {
                Files.move(targetDirUnderlineConcluido.toPath(), targetDirDotConcluido.toPath(), StandardCopyOption.REPLACE_EXISTING);
                System.out.println("Diret\u00f3rio movido com sucesso: " + targetDirDotConcluido.getAbsolutePath());
            }
            catch (IOException e) {
                System.err.println("Erro ao mover o diret\u00f3rio: " + e.getMessage());
                return;
            }
        }
        if (!targetDirDotConcluido.exists() && !targetDirDotConcluido.mkdirs()) {
            System.err.println("N\u00e3o foi poss\u00edvel criar o diret\u00f3rio de destino: " + targetDirDotConcluido.getAbsolutePath());
            return;
        }
        File[] files = baseDirFile.listFiles();
        if (files != null) {
            for (File file : files) {
                if (!file.isDirectory() || !file.getName().startsWith("2024") && !file.getName().startsWith("2025")) continue;
                try {
                    Path targetPath = new File(targetDirDotConcluido, file.getName()).toPath();
                    Files.move(file.toPath(), targetPath, StandardCopyOption.REPLACE_EXISTING);
                    System.out.println("Pasta movida com sucesso: " + file.getName());
                }
                catch (IOException e) {
                    System.err.println("Erro ao mover a pasta " + file.getName() + ": " + e.getMessage());
                }
            }
        }
    }
}

