/*
 * Decompiled with CFR 0.152.
 */
package br.com.dsfnet.gpd.client.svn;

import br.com.dsfnet.gpd.client.desenvolvimento.DesenvolvimentoEntity;
import br.com.dsfnet.gpd.client.empacotamento.EmpacotamentoEntity;
import br.com.dsfnet.gpd.client.exception.VersionamentoException;
import br.com.dsfnet.gpd.client.sistema.SistemaEntity;
import br.com.dsfnet.gpd.client.svn.BibliotecaSvn;
import br.com.dsfnet.gpd.client.type.PublicacaoType;
import br.com.dsfnet.gpd.client.type.TecnologiaType;
import br.com.dsfnet.gpd.client.util.PastaUtil;
import br.com.dsfnet.gpd.client.versionamento.VersionamentoEntity;
import br.com.jarch.svn.LogSvn;
import br.com.jarch.svn.SvnFachada;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.URL;
import java.util.Collection;
import java.util.List;

public class VersionamentoSvn
implements Serializable {
    public void inicioVersionamento(String servidorSvn, String loginSvn, String senhaSvn, PublicacaoType publicacaoType, DesenvolvimentoEntity desenvolvimentoEntity, EmpacotamentoEntity empacotamentoEntity, List<String> log, OutputStream outputStream) throws VersionamentoException {
        try {
            Object branch;
            SistemaEntity aplicacao;
            if (publicacaoType == PublicacaoType.INDIVIDUAL) {
                aplicacao = desenvolvimentoEntity.getSistemaEntity();
                branch = desenvolvimentoEntity.getNumeroSol();
            } else {
                aplicacao = empacotamentoEntity.getSistemaEntity();
                branch = empacotamentoEntity.getVersao();
            }
            File pastaTrabalho = PastaUtil.getPastaTrabalho(loginSvn, aplicacao.getServidorVersionamento(), (String)branch);
            URL urlTrunk = PastaUtil.getUrlTrunk(servidorSvn, aplicacao.getProjetoSvn());
            if (pastaTrabalho.exists()) {
                PastaUtil.remover(pastaTrabalho);
            }
            SvnFachada svnFachada = new SvnFachada(loginSvn, senhaSvn, outputStream);
            svnFachada.checkout(urlTrunk, pastaTrabalho, 0L);
            if (publicacaoType == PublicacaoType.PACOTE) {
                URL urlVersao = PastaUtil.getUrlBranch(servidorSvn, aplicacao.getProjetoSvn(), (String)branch);
                svnFachada.merge(urlVersao, pastaTrabalho);
            } else {
                URL urlSol = PastaUtil.getUrlBranch(servidorSvn, aplicacao.getProjetoSvn(), (String)branch);
                svnFachada.merge(urlSol, pastaTrabalho);
            }
            if (aplicacao.getTecnologia() == TecnologiaType.JAVA) {
                BibliotecaSvn bibliotecaSvn = new BibliotecaSvn();
                bibliotecaSvn.baixaBiblioteca(servidorSvn, loginSvn, senhaSvn);
            }
            log.addAll(svnFachada.getLog());
        }
        catch (Exception ex) {
            throw new VersionamentoException(ex.getMessage());
        }
    }

    public void descarteVersionamento(String loginSvn, VersionamentoEntity versionamento, List<String> log) throws Exception {
        File pastaTrabalho = PastaUtil.getPastaTrabalho(loginSvn, versionamento.getSistemaEntity().getServidorVersionamento(), versionamento.getVersao());
        PastaUtil.remover(pastaTrabalho);
        LogSvn logUtil = new LogSvn();
        logUtil.formatBeginMiddleEnd(log, "DESCARTAR VERSIONAMENTO", new String[]{"Working Copy " + pastaTrabalho.getAbsolutePath() + " EXCLU\u00cdDO"});
    }

    public void fimVersionamento(String servidorSvn, String loginSvn, String senhaSvn, PublicacaoType publicacaoType, VersionamentoEntity versionamento, Collection<String> listaArquivoIgnorar, List<String> log, OutputStream outputStream) throws Exception {
        try {
            Object branch = versionamento.getNumeroSol() == null ? versionamento.getVersao() : versionamento.getNumeroSol();
            File pastaTrabalho = PastaUtil.getPastaTrabalho(loginSvn, versionamento.getSistemaEntity().getServidorVersionamento(), (String)branch);
            URL urlTrunk = PastaUtil.getUrlTrunk(servidorSvn, versionamento.getSistemaEntity().getProjetoSvn());
            SvnFachada svnFachada = new SvnFachada(loginSvn, senhaSvn, outputStream);
            svnFachada.commit(urlTrunk, pastaTrabalho, listaArquivoIgnorar, "FINALIZAR VERSIONAMENTO");
            URL urlTag = PastaUtil.getUrlTag(servidorSvn, versionamento.getSistemaEntity().getProjetoSvn(), versionamento.getTag());
            String comentarioSvn = publicacaoType == PublicacaoType.INDIVIDUAL ? "FINALIZAR VERSIONAMENTO DA SOL: " + versionamento.getNumeroSol() : "FINALIZAR VERSIONAMENTO DA VERSAO: " + versionamento.getVersao();
            svnFachada.copy(urlTrunk, urlTag, comentarioSvn);
            log.addAll(svnFachada.getLog());
        }
        catch (IOException ex) {
            throw new VersionamentoException(ex.getMessage());
        }
    }

    public void verificaConflito(String loginSvn, String senhaSvn, VersionamentoEntity versionamento, String branch, OutputStream outputStream) throws Exception {
        SvnFachada svnFachada = new SvnFachada(loginSvn, senhaSvn, outputStream);
        File pastaTrabalho = PastaUtil.getPastaTrabalho(loginSvn, versionamento.getSistemaEntity().getServidorVersionamento(), branch);
        svnFachada.verificaConflito(pastaTrabalho);
    }
}

