/*
 * Decompiled with CFR 0.152.
 */
package br.com.dsfnet.gpd.client.svn;

import br.com.dsfnet.gpd.client.exception.DesenvolvimentoException;
import br.com.dsfnet.gpd.client.form.AplicacaoForm;
import br.com.dsfnet.gpd.client.form.DesenvolvimentoForm;
import br.com.dsfnet.gpd.client.svn.BibliotecaSvn;
import br.com.dsfnet.gpd.client.type.TecnologiaType;
import br.com.dsfnet.gpd.client.util.PastaUtil;
import br.com.jarch.svn.LogSvn;
import br.com.jarch.svn.StatusArquivoForm;
import br.com.jarch.svn.SvnFachada;
import java.io.File;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class DesenvolvimentoSvn {
    public List<String> inicioDesenvolvimento(String servidorSvn, String loginSvn, String senhaSvn, String branch, AplicacaoForm aplicacaoForm, boolean mergeTrunk, OutputStream outputStream) throws DesenvolvimentoException {
        try {
            File pastaTrabalho;
            URL urlTrunk = PastaUtil.getUrlTrunk(servidorSvn, aplicacaoForm.getProjetoSvn());
            URL urlBranch = PastaUtil.getUrlBranch(servidorSvn, aplicacaoForm.getProjetoSvn(), branch);
            SvnFachada svnFachada = new SvnFachada(loginSvn, senhaSvn, outputStream);
            if (branch.equals("1") && svnFachada.existeRepositorio(urlBranch)) {
                svnFachada.delete(urlBranch, "BranchDE USO EXCLUSIVO DE DE TESTE DO GPD");
            }
            if (!svnFachada.existeRepositorio(urlBranch)) {
                svnFachada.copy(urlTrunk, urlBranch, "INICIO DESENVOLVIMENTO");
            }
            if ((pastaTrabalho = PastaUtil.getPastaTrabalho(loginSvn, aplicacaoForm.getServidorDesenvolvimento(), branch)).exists()) {
                PastaUtil.remover(pastaTrabalho);
            }
            svnFachada.checkout(urlBranch, pastaTrabalho);
            if (aplicacaoForm.getTecnologia() == TecnologiaType.JAVA) {
                BibliotecaSvn bibliotecaSvn = new BibliotecaSvn();
                bibliotecaSvn.baixaBiblioteca(servidorSvn, loginSvn, senhaSvn);
            }
            return svnFachada.getLog();
        }
        catch (Exception ex) {
            throw new DesenvolvimentoException(ex.getMessage());
        }
    }

    public List<String> descarteDesenvolvimento(String login, String pastaDesenvolvimento, String branch) throws DesenvolvimentoException {
        try {
            File pastaTrabalho = PastaUtil.getPastaTrabalho(login, pastaDesenvolvimento, branch);
            PastaUtil.remover(pastaTrabalho);
            ArrayList<String> log = new ArrayList<String>();
            LogSvn logUtil = new LogSvn();
            logUtil.formatBeginMiddleEnd(log, "DESCARTAR ALTERA\u00c7\u00d5ES", new String[]{"Working Copy " + pastaTrabalho.getAbsolutePath() + " EXCLU\u00cdDO"});
            return log;
        }
        catch (Exception ex) {
            throw new DesenvolvimentoException(ex.getMessage());
        }
    }

    public List<String> salvaDesenvolvimento(String servidorSvn, String projetoSvn, String login, String senha, String servidorDesenvolvimento, String branch, Collection<String> listaArquivoIgnorar, String comentario, OutputStream outputStream) throws DesenvolvimentoException {
        try {
            File pastaTrabalho = PastaUtil.getPastaTrabalho(login, servidorDesenvolvimento, branch);
            URL urlBranch = PastaUtil.getUrlBranch(servidorSvn, projetoSvn, branch.toString());
            SvnFachada svnFachada = new SvnFachada(login, senha, outputStream);
            svnFachada.commit(urlBranch, pastaTrabalho, listaArquivoIgnorar, String.format("SOL: %s - %s", branch, comentario));
            ArrayList<String> log = new ArrayList<String>(svnFachada.getLog());
            LogSvn logUtil = new LogSvn();
            logUtil.formatBeginMiddleEnd(log, "SALVA ALTERA\u00c7\u00d5ES", new String[]{"Working Copy " + pastaTrabalho.getAbsolutePath() + " SALVO"});
            return log;
        }
        catch (Exception ex) {
            throw new DesenvolvimentoException(ex.getMessage());
        }
    }

    public List<String> finalizaDesenvolvimento(String servidorSvn, DesenvolvimentoForm desenvolvimentoForm, AplicacaoForm aplicacaoForm, Collection<String> listaArquivoIgnorar, OutputStream outputStream) throws DesenvolvimentoException {
        try {
            File pastaTrabalho = PastaUtil.getPastaTrabalho(desenvolvimentoForm.getLogin(), aplicacaoForm.getServidorDesenvolvimento(), desenvolvimentoForm.getBranch());
            URL urlBranch = PastaUtil.getUrlBranch(servidorSvn, aplicacaoForm.getProjetoSvn(), desenvolvimentoForm.getBranch());
            SvnFachada svnFachada = new SvnFachada(desenvolvimentoForm.getLogin(), desenvolvimentoForm.getSenha(), outputStream);
            svnFachada.commit(urlBranch, pastaTrabalho, listaArquivoIgnorar, String.format("SOL: %s - %s", desenvolvimentoForm.getBranch(), desenvolvimentoForm.getComentario()));
            return svnFachada.getLog();
        }
        catch (Exception ex) {
            throw new DesenvolvimentoException(ex.getMessage());
        }
    }

    public void validacaoWorkingCopyBranch(String servidorSvn, String projetoSvn, String login, String senha, String servidorDesenvolvimento, String branch, OutputStream outputStream) throws Exception {
        try {
            File pastaTrabalho = PastaUtil.getPastaTrabalho(login, servidorDesenvolvimento, branch);
            URL urlBranch = PastaUtil.getUrlBranch(servidorSvn, projetoSvn, branch);
            SvnFachada svnFachada = new SvnFachada(login, senha, outputStream);
            URL urlWorkingCopy = svnFachada.getRepositorio(pastaTrabalho);
            String strUrlBranch = urlBranch.toString().replaceAll("//", "/");
            String strUrlWorkingCopy = urlWorkingCopy.toString().replaceAll("//", "/");
            if (strUrlBranch.length() > strUrlWorkingCopy.length()) {
                strUrlBranch = strUrlBranch.substring(0, strUrlWorkingCopy.length());
            } else if (strUrlWorkingCopy.length() > strUrlBranch.length()) {
                strUrlWorkingCopy = strUrlWorkingCopy.substring(0, strUrlBranch.length());
            }
            if (!strUrlBranch.equals(strUrlWorkingCopy)) {
                String mensagem = String.format("Working Copy [%s] N\u00c3O est\u00e1 apontando para a branch correta [%s]", strUrlWorkingCopy, strUrlBranch);
                throw new DesenvolvimentoException(mensagem);
            }
        }
        catch (DesenvolvimentoException | MalformedURLException ex) {
            throw new DesenvolvimentoException(ex.getMessage());
        }
    }

    public List<StatusArquivoForm> listaArquivoNaoComitado(String login, String senha, AplicacaoForm aplicacaoForm, String branch, OutputStream outputStream) throws Exception {
        SvnFachada svnFachada = new SvnFachada(login, senha, outputStream);
        File pastaTrabalho = PastaUtil.getPastaTrabalho(login, aplicacaoForm.getServidorDesenvolvimento(), branch);
        return svnFachada.listaArquivoNaoComitado(pastaTrabalho);
    }

    public List<String> diferencaArquivo(String login, String senha, String arquivo, OutputStream outputStream) throws Exception {
        SvnFachada svnFachada = new SvnFachada(login, senha, outputStream);
        return svnFachada.diferencaArquivo(arquivo);
    }

    public List<String> descarte(String login, String senha, String pasta, String branch, OutputStream outputStream) throws Exception {
        SvnFachada svnFachada = new SvnFachada(login, senha, outputStream);
        return svnFachada.descarte(PastaUtil.getPastaTrabalho(login, pasta, branch), outputStream);
    }
}

