/*
 * Decompiled with CFR 0.152.
 */
package br.com.dsfnet.gpd.client.sistema;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.stream.Collectors;

public enum ModuloType {
    ADM("ADM", "ADM"),
    ADW("ADMWEB", "ADM WEB"),
    EJB("EJB", "EJB"),
    JOB("JOB", "JOB"),
    WSR("WSR", "Servi\u00e7o"),
    WS1("WS10", "Servi\u00e7o ABRASF 1.0"),
    WS2("WS203", "Servi\u00e7o ABRASF 2.03"),
    WEB("WEB", "WEB"),
    SWB("SO-WEB", "S\u00f3 WEB");

    private final String abbreviation;
    private final String description;

    private ModuloType(String abbreviation, String description) {
        this.abbreviation = abbreviation;
        this.description = description;
    }

    public String getAbbreviation() {
        return this.abbreviation;
    }

    public String getDescription() {
        return this.description;
    }

    public static ModuloType abbreviationToEnum(String abbreviation) {
        return Arrays.stream(ModuloType.values()).filter(m -> m.getAbbreviation().equals(abbreviation)).findAny().orElse(null);
    }

    public static ModuloType descriptionToEnum(String description) {
        return Arrays.stream(ModuloType.values()).filter(m -> m.getDescription().equals(description)).findAny().orElse(null);
    }

    public static Collection<ModuloType> getCollection() {
        return Arrays.stream(ModuloType.values()).collect(Collectors.toCollection(ArrayList::new));
    }

    public String toString() {
        return this.getDescription();
    }

    public boolean isWeb() {
        return this.equals((Object)WEB) || this.equals((Object)SWB);
    }
}

