/*
 * Decompiled with CFR 0.152.
 */
package br.com.dsfnet.gpd.client.log;

import br.com.dsfnet.gpd.client.log.LogPlanejamentoEntity;
import br.com.dsfnet.gpd.client.log.LogPlanejamentoRepository;
import br.com.dsfnet.gpd.client.planejamento.PlanejamentoEntity;
import br.com.dsfnet.gpd.client.planejamento.PlanejamentoRepository;
import br.com.dsfnet.gpd.client.usuario.UsuarioEntity;
import br.com.dsfnet.gpd.client.usuario.UsuarioRepository;
import br.com.jarch.core.annotation.JArchDao;
import br.com.jarch.core.crud.dao.CrudDao;
import jakarta.transaction.Transactional;
import java.util.Collection;
import java.util.Date;

@JArchDao
public class LogPlanejamentoDao
extends CrudDao<LogPlanejamentoEntity>
implements LogPlanejamentoRepository {
    @Override
    public void iniciaProcessoAutomatico(Long idPlanejamento, String login) {
        this.removeLog(idPlanejamento);
        this.incluir(idPlanejamento, login, new Date(), "Solicitou o empacotamento autom\u00e1tico");
    }

    @Override
    public UsuarioEntity retornaUsuario(Long idPlanejamento) {
        Collection lista = this.searchAllBy("planejamentoEntity.id", idPlanejamento);
        LogPlanejamentoEntity logPlanejamentoEntity = lista.stream().findAny().orElse(null);
        return logPlanejamentoEntity.getUsuarioEntity();
    }

    @Override
    public void incluir(Long idPlanejamento, Date data, String mensagem) {
        UsuarioEntity usuarioEntity = this.retornaUsuario(idPlanejamento);
        this.incluir(idPlanejamento, usuarioEntity.getLogin(), data, mensagem);
    }

    @Override
    @Transactional
    public void incluir(Long idPlanejamento, String login, Date data, String mensagem) {
        PlanejamentoEntity planejamentoEntity = PlanejamentoRepository.getInstance().pesquisar(idPlanejamento);
        UsuarioEntity usuarioEntity = (UsuarioEntity)UsuarioRepository.getInstance().searchOneBy("login", login);
        LogPlanejamentoEntity logPlanejamentoEntity = new LogPlanejamentoEntity();
        logPlanejamentoEntity.setData(data);
        logPlanejamentoEntity.setMensagem(mensagem);
        logPlanejamentoEntity.setPlanejamentoEntity(planejamentoEntity);
        logPlanejamentoEntity.setUsuarioEntity(usuarioEntity);
        this.getEntityManager().persist((Object)logPlanejamentoEntity);
    }

    @Override
    @Transactional
    public void removeLog(Long idPlanejamento) {
        Collection lista = this.searchAllBy("planejamentoEntity.id", idPlanejamento);
        for (LogPlanejamentoEntity logPlanejamentoEntity : lista) {
            this.getEntityManager().remove((Object)logPlanejamentoEntity);
        }
    }
}

