/*
 * Decompiled with CFR 0.152.
 */
package br.com.dsfnet.gpd.client.fachada;

import br.com.dsfnet.gpd.client.exception.LoginException;
import br.com.dsfnet.gpd.client.form.AutenticacaoForm;
import br.com.dsfnet.gpd.client.usuario.UsuarioRepository;
import br.com.jarch.core.annotation.JArchService;
import br.com.jarch.svn.SvnFachada;
import br.com.jarch.util.LogUtils;
import jakarta.enterprise.inject.spi.CDI;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.net.URL;

@JArchService
public class LoginService
implements Serializable {
    public static LoginService getInstance() {
        return (LoginService)CDI.current().select(LoginService.class, new Annotation[0]).get();
    }

    public void efetuaLogin(AutenticacaoForm autenticacaoForm) throws LoginException {
        if (autenticacaoForm.getServidorSvn() == null || autenticacaoForm.getServidorSvn().isEmpty()) {
            throw new LoginException("Servidor SVN obrigat\u00f3rio");
        }
        if (autenticacaoForm.getLogin() == null || autenticacaoForm.getLogin().isEmpty()) {
            throw new LoginException("Login obrigat\u00f3rio");
        }
        if (autenticacaoForm.getSenha() == null || autenticacaoForm.getSenha().isEmpty()) {
            throw new LoginException("Senha obrigat\u00f3rio");
        }
        if (!this.loginValido(autenticacaoForm)) {
            throw new LoginException("Usu\u00e1rio/Senha inv\u00e1lido");
        }
        UsuarioRepository.getInstance().incluiSeNaoExistir(autenticacaoForm.getLogin());
    }

    private boolean loginValido(AutenticacaoForm autenticacaoForm) {
        LogUtils.generate((String)("######### TENTANDO LOGIN: " + autenticacaoForm.getLogin()));
        SvnFachada svnFachada = new SvnFachada(autenticacaoForm.getLogin(), autenticacaoForm.getSenha(), null);
        try {
            return svnFachada.existeRepositorio(new URL(autenticacaoForm.getServidorSvn()));
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }
}

