/*
 * Decompiled with CFR 0.152.
 */
package br.com.dsfnet.gpd.client;

import br.com.dsfnet.gpd.client.form.PublicacaoForm;
import br.com.dsfnet.gpd.client.sistema.AmbienteType;
import br.com.dsfnet.gpd.client.sistema.LocalType;
import br.com.dsfnet.gpd.client.sistema.ModuloType;
import br.com.dsfnet.gpd.client.sistema.VersaoJavaType;
import br.com.dsfnet.gpd.client.util.PastaUtil;
import br.com.dsfnet.gpd.client.util.Utils;
import br.com.jarch.svn.SvnFachada;
import br.com.jarch.util.DateUtils;
import br.com.jarch.util.FileUtils;
import br.com.jarch.util.LogUtils;
import br.com.jarch.util.NumberUtils;
import br.com.jarch.util.OperationSystemUtils;
import br.com.jarch.util.SleepUtils;
import br.com.jarch.util.SshUtils;
import br.com.jarch.util.StringUtils;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.invoke.CallSite;
import java.net.URL;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class PublicacaoDomain {
    private static final int TENTATIVAS_PUBLICACAO = 300;
    private final String servidorSvn;
    private final String loginSvn;
    private final String senhaSvn;
    private final String loginSshLocal;
    private final String senhaSshLocal;
    private final String loginSshRemote;
    private final String senhaSshRemote;
    private List<LocalType> locaisSelecionados = new ArrayList<LocalType>();
    private List<AmbienteType> ambientesSelecionados = new ArrayList<AmbienteType>();
    private List<ModuloType> modulosSelecionados = new ArrayList<ModuloType>();
    private List<PublicacaoForm> publicacoesSistema = new ArrayList<PublicacaoForm>();
    private PublicacaoForm publicacaoForm;
    private String projetoSvn;
    private String branchPacote;
    private String nomeAlternativo;
    private boolean mostraComandoSql;
    private boolean trunk;
    private VersaoJavaType versaoJava;
    private boolean viaServidorAplicacao;
    private OutputStream outputStream;
    private Map<String, PublicacaoForm> ultimaPublicacao = new HashMap<String, PublicacaoForm>();

    public PublicacaoDomain(String servidorSvn, String loginSvn, String senhaSvn, String loginSshLocal, String senhaSshLocal, String loginSshRemote, String senhaSshRemote, OutputStream outputStream) {
        this.servidorSvn = servidorSvn;
        this.loginSvn = loginSvn;
        this.senhaSvn = senhaSvn;
        this.loginSshLocal = loginSshLocal;
        this.senhaSshLocal = senhaSshLocal;
        this.loginSshRemote = loginSshRemote;
        this.senhaSshRemote = senhaSshRemote;
        this.outputStream = outputStream;
    }

    public void publicaAplicacao() {
        try {
            this.valida();
            this.baixaFontesSvn();
            this.compilaCopiaPublica();
            this.validaWarsPublicados();
            this.apagaFontes();
            this.ultimaPublicacao.clear();
        }
        catch (Exception ex) {
            this.log(ex.getMessage());
            throw ex;
        }
    }

    public PublicacaoDomain locais(List<LocalType> locaisSelecionados) {
        this.locaisSelecionados = locaisSelecionados;
        return this;
    }

    public PublicacaoDomain ambientes(List<AmbienteType> ambientesSelecionados) {
        this.ambientesSelecionados = ambientesSelecionados;
        return this;
    }

    public PublicacaoDomain modulos(List<ModuloType> modulosSelecionados) {
        this.modulosSelecionados = modulosSelecionados;
        return this;
    }

    public PublicacaoDomain versaoJava(VersaoJavaType versaoJava) {
        this.versaoJava = versaoJava;
        return this;
    }

    public List<PublicacaoForm> getPublicacoesSistema() {
        return this.publicacoesSistema;
    }

    public void setPublicacoesSistema(List<PublicacaoForm> publicacoesSistema) {
        this.publicacoesSistema = publicacoesSistema;
    }

    public PublicacaoDomain projetoSvn(String projetoSvn) {
        this.projetoSvn = projetoSvn;
        return this;
    }

    public PublicacaoDomain branchPacote(String branchPacote) {
        this.branchPacote = branchPacote;
        return this;
    }

    public PublicacaoDomain nomeAlternativo(String nomeAlternativo) {
        this.nomeAlternativo = nomeAlternativo;
        return this;
    }

    public PublicacaoDomain mostraComandoSql(boolean mostraComandoSql) {
        this.mostraComandoSql = mostraComandoSql;
        return this;
    }

    public PublicacaoDomain trunk(boolean trunk) {
        this.trunk = trunk;
        return this;
    }

    public PublicacaoDomain viaServidorAplicacao() {
        this.viaServidorAplicacao = true;
        return this;
    }

    private void apagaFontes() {
        File file = new File(this.getPastaSistemaBranchTempLocal());
        if (!file.exists()) {
            return;
        }
        this.log("Apagando: " + this.getPastaSistemaBranchTempLocal());
        if (OperationSystemUtils.isLinux() || OperationSystemUtils.isMac()) {
            this.sshLocal("sudo rm -rf " + this.getPastaSistemaBranchTempLocal());
        } else {
            FileUtils.remove((File)file);
        }
    }

    private void validaWarsPublicados() {
        ArrayList<String> erros = new ArrayList<String>();
        for (LocalType local : this.locaisSelecionados) {
            for (AmbienteType ambiente : this.ambientesSelecionados) {
                for (ModuloType modulo : this.modulosSelecionados) {
                    this.log("Analisando Local: " + String.valueOf((Object)local) + " Ambiente: " + String.valueOf((Object)ambiente) + " M\u00f3dulo: " + String.valueOf((Object)modulo));
                    List<PublicacaoForm> publicacoes = this.getPublicacoes(local, ambiente, modulo);
                    for (PublicacaoForm publicacaoFormAtual : publicacoes) {
                        try {
                            this.publicacaoForm = publicacaoFormAtual;
                            this.publicacaoForm.setNomeAlternativo(this.nomeAlternativo);
                            this.validaWarPublicado();
                            this.adicionaPublicado(publicacaoFormAtual);
                        }
                        catch (Exception ex) {
                            this.log(ex.getMessage());
                            erros.add(ex.getMessage());
                        }
                    }
                }
            }
        }
        if (erros.size() > 0) {
            throw new RuntimeException("Houve ERRO(s) ao publicar os WAR(s):\n" + String.join((CharSequence)"\n", erros));
        }
    }

    private String geraChavePublicado(PublicacaoForm publicacaoForm) {
        return "Local: %s - Ambiente: %s - Modulo: %s - Servidor: %s".formatted(new Object[]{publicacaoForm.getLocal(), publicacaoForm.getAmbiente(), publicacaoForm.getModulo().name(), publicacaoForm.getServidor()});
    }

    private void valida() {
        if (this.isPublicadoParcialmente()) {
            return;
        }
        if (StringUtils.isNotEmpty((String)this.nomeAlternativo) && this.modulosSelecionados.stream().anyMatch(m -> !m.isWeb())) {
            throw new RuntimeException("Nome Alternativo permitido somente para M\u00f3dulo WEB");
        }
        for (LocalType local : this.locaisSelecionados) {
            this.log("Analisando Local: " + String.valueOf((Object)local));
            if (this.ambientesSelecionados.isEmpty()) {
                throw new RuntimeException("Local: " + String.valueOf((Object)local) + "Ambiente N\u00c3O LOCALIZADO");
            }
            for (AmbienteType ambiente : this.ambientesSelecionados) {
                this.log("Analisando Local: " + String.valueOf((Object)local) + " Ambiente: " + String.valueOf((Object)ambiente));
                if (this.modulosSelecionados.isEmpty()) {
                    throw new RuntimeException("Ambiente: " + String.valueOf((Object)ambiente) + " M\u00d3DULO N\u00c3O LOCALIZADO");
                }
                for (ModuloType modulo : this.modulosSelecionados) {
                    this.log("Analisando Local: " + String.valueOf((Object)local) + " Ambiente: " + String.valueOf((Object)ambiente) + " M\u00f3dulo: " + String.valueOf((Object)modulo));
                    List<PublicacaoForm> publicacoes = this.getPublicacoes(local, ambiente, modulo);
                    if (!publicacoes.isEmpty()) continue;
                    throw new RuntimeException("Local: " + String.valueOf((Object)local) + " Ambiente: " + String.valueOf((Object)ambiente) + " M\u00f3dulo: " + String.valueOf((Object)modulo) + " N\u00c3O LOCALIZADO");
                }
            }
        }
    }

    private List<PublicacaoForm> getPublicacoes(LocalType local, AmbienteType ambiente, ModuloType modulo) {
        return this.publicacoesSistema.stream().filter(p -> p.getLocal().equals((Object)local)).filter(p -> p.getAmbiente().equals((Object)ambiente)).filter(p -> p.getModulo().equals((Object)modulo)).sorted(Comparator.comparing(PublicacaoForm::getComandoAntesCompilacao).reversed().thenComparing(PublicacaoForm::getArtefato)).toList();
    }

    private void compilaCopiaPublica() {
        boolean primeiraPublicacao = this.ultimaPublicacao.isEmpty();
        String ultimoComandoAntesCompilacao = "";
        for (LocalType local : this.locaisSelecionados) {
            List<AmbienteType> ambientes = this.ambientesSelecionados;
            for (AmbienteType ambiente : ambientes) {
                List<ModuloType> modulos = this.modulosSelecionados;
                boolean primeiroModulo = true;
                for (ModuloType modulo : modulos) {
                    String versao = DateUtils.format((String)"yyyy.MM.dd.HHmm", (LocalDateTime)LocalDateTime.now());
                    List<PublicacaoForm> publicacoes = this.getPublicacoes(local, ambiente, modulo);
                    Iterator<PublicacaoForm> iterator = publicacoes.iterator();
                    while (iterator.hasNext()) {
                        boolean scriptAntesCompilacaoDiferenteUltimo;
                        PublicacaoForm publicacaoFormAtual;
                        this.publicacaoForm = publicacaoFormAtual = iterator.next();
                        this.publicacaoForm.setNomeAlternativo(this.nomeAlternativo);
                        if (this.isServidorContigenciaInativo()) {
                            this.publicacaoForm.inacessivel();
                            continue;
                        }
                        if (this.isPublicado(this.publicacaoForm)) continue;
                        if (this.isPublicadoParcialmente()) {
                            this.apagaAplicacaoServidor();
                            this.copiaAplicacaoServidor();
                            this.publicaAplicacaoServidor();
                            continue;
                        }
                        if (!publicacaoFormAtual.isComandoAntesCompilacao()) {
                            ultimoComandoAntesCompilacao = this.publicacaoForm.getComandoAntesCompilacao();
                        }
                        boolean bl = scriptAntesCompilacaoDiferenteUltimo = !this.publicacaoForm.getComandoAntesCompilacao().equals(ultimoComandoAntesCompilacao);
                        if (primeiraPublicacao || scriptAntesCompilacaoDiferenteUltimo) {
                            this.executaScriptAntesCompilacao();
                            this.compilaAplicacao(local, ambiente, versao);
                        }
                        this.apagaAplicacaoServidor();
                        this.copiaAplicacaoServidor();
                        this.publicaAplicacaoServidor();
                        if (primeiroModulo && publicacoes.size() > 1) {
                            this.validaWarPublicado();
                        }
                        primeiroModulo = false;
                        primeiraPublicacao = false;
                        ultimoComandoAntesCompilacao = this.publicacaoForm.getComandoAntesCompilacao();
                    }
                }
            }
        }
    }

    private boolean isPublicadoParcialmente() {
        return !this.ultimaPublicacao.isEmpty();
    }

    private boolean isPublicado(PublicacaoForm publicacaoFormAtual) {
        String chave = this.geraChavePublicado(publicacaoFormAtual);
        return this.ultimaPublicacao.get(chave) != null;
    }

    private void adicionaPublicado(PublicacaoForm publicacaoFormAtual) {
        String chavePublicado = this.geraChavePublicado(publicacaoFormAtual);
        this.ultimaPublicacao.put(chavePublicado, publicacaoFormAtual);
    }

    private boolean isServidorContigenciaInativo() {
        boolean active = SshUtils.isConnectionSuccess((String)this.publicacaoForm.getServidor(), (int)this.publicacaoForm.getPorta(), (String)this.loginSshRemote, (String)this.senhaSshRemote, (OutputStream)this.outputStream);
        if (active) {
            return false;
        }
        return this.publicacaoForm.isServidorContingencia();
    }

    private void logServidorContingenciaInativo() {
        this.log("############################################");
        this.log(this.publicacaoForm.getInfo(this.branchPacote));
        this.log("- CONTINGENCIA INATIVO");
        this.log("############################################");
    }

    private void logPublicadoServidor() {
        this.log("############################################");
        this.log(this.publicacaoForm.getInfo(this.branchPacote));
        this.log("- PUBLICADO NO SERVIDOR");
        this.log("############################################");
    }

    private void validaWarPublicado() {
        if (this.publicacaoForm.isInacessivel()) {
            this.logServidorContingenciaInativo();
            return;
        }
        this.log("@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@");
        this.log("@@@ AGUARDANDO DEPLOY NO SERVIDOR");
        this.log(this.publicacaoForm.getInfo("@@@", this.branchPacote));
        LocalDateTime inicioTentativa = LocalDateTime.now();
        for (int tentativa = 1; tentativa <= 300; ++tentativa) {
            LocalTime inicio = LocalTime.now();
            this.validaWarDentroDeployment();
            this.apagaWarUndeployed();
            this.verificaWarFailed();
            if (this.isPublicadoSucesso()) {
                this.log("@@@ PUBLICADO COM SUCESSO");
                this.log("@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@");
                this.logPublicadoServidor();
                return;
            }
            if (this.isReiniciaServidor(tentativa, inicioTentativa)) {
                new Thread(() -> this.sshRemote(this.publicacaoForm.getComandoAposPublicacao())).start();
                inicioTentativa = LocalDateTime.now();
            }
            LocalTime fim = LocalTime.now();
            String msg = "@@@ Aguardando Publica\u00e7\u00e3o *** " + this.publicacaoForm.getServidor() + " *** [" + NumberUtils.formatZeroLeft((Number)tentativa, (int)3) + "/300]";
            this.log(msg);
            if (ChronoUnit.SECONDS.between(inicio, fim) > 1L) continue;
            SleepUtils.pauseSeconds((int)1);
        }
        PublicacaoDomain.lancaExcecaoErroDurantePublicacao("Tempo ESGOTADO para publica\u00e7\u00e3o do " + this.publicacaoForm.getDeploymentWar() + " em " + String.valueOf((Object)this.publicacaoForm.getAmbiente()) + " Servidor " + this.publicacaoForm.getServidor());
    }

    private boolean isReiniciaServidor(int tentativa, LocalDateTime inicioTentativa) {
        if (!this.publicacaoForm.isComandoAposPublicacao()) {
            return false;
        }
        long tempoSegundos = Math.abs(ChronoUnit.SECONDS.between(inicioTentativa, LocalDateTime.now()));
        return tempoSegundos > 60L && tentativa <= 60;
    }

    private void publicaAplicacaoServidor() {
        ArrayList<String> commandsRemote = new ArrayList<String>();
        if (StringUtils.isNullOrEmpty((String)this.nomeAlternativo)) {
            commandsRemote.add("sudo /usr/local/sbin/bkfile " + this.publicacaoForm.getDeploymentWar());
            commandsRemote.add("sudo rm " + this.publicacaoForm.getDeploymentWarUltimoBackup());
            commandsRemote.add("sudo cp " + this.publicacaoForm.getDeploymentWar() + " " + this.publicacaoForm.getDeploymentWarUltimoBackup());
            commandsRemote.add("sudo mv " + this.publicacaoForm.getDeploymentWar() + " " + this.publicacaoForm.getDeploymentWarBackupAgora());
            commandsRemote.add("sudo rm " + this.publicacaoForm.getDeploymentWar() + ".*");
        }
        commandsRemote.add("sudo mv " + this.getPastaSistemaBranchTempServer() + File.separator + this.publicacaoForm.getNomeWar() + " " + this.publicacaoForm.getPastaDeployment());
        this.sshRemote(commandsRemote);
    }

    private boolean isPublicadoSucesso() {
        return this.existsFileRemote(this.publicacaoForm.getDeploymentWarDeployed());
    }

    private void verificaWarFailed() {
        boolean existeWarFailed = this.existsFileRemote(this.publicacaoForm.getDeploymentWarFailed());
        if (existeWarFailed) {
            this.sshRemote("cat " + this.publicacaoForm.getDeploymentWarFailed());
            PublicacaoDomain.lancaExcecaoErroDurantePublicacao("Falha ao publicar o " + this.publicacaoForm.getDeploymentWar() + " em " + String.valueOf((Object)this.publicacaoForm.getAmbiente()) + " no servidor " + this.publicacaoForm.getServidor());
        }
    }

    private void validaWarDentroDeployment() {
        for (int tentativa = 1; tentativa <= 3; ++tentativa) {
            boolean existeWarPastaDeployment;
            boolean existeWarPastaToDeploy = this.existsFileRemote(this.publicacaoForm.getToDeployWar());
            if (existeWarPastaToDeploy) {
                this.sshRemote("sudo mv " + this.publicacaoForm.getToDeployWar() + " " + this.publicacaoForm.getDeploymentWar());
            }
            if ((existeWarPastaDeployment = this.existsFileRemote(this.publicacaoForm.getDeploymentWar())) || existeWarPastaToDeploy) {
                return;
            }
            SleepUtils.pauseSeconds((int)1);
        }
        PublicacaoDomain.lancaExcecaoErroDurantePublicacao("Erro na tentativa de localiza\u00e7\u00e3o do " + this.publicacaoForm.getDeploymentWar() + " em " + String.valueOf((Object)this.publicacaoForm.getAmbiente()) + " no servidor " + this.publicacaoForm.getServidor());
    }

    private boolean existsFileRemote(String file) {
        return SshUtils.existsFile((String)this.publicacaoForm.getServidor(), (int)this.publicacaoForm.getPorta(), (String)this.loginSshRemote, (String)this.senhaSshRemote, (String)file, (OutputStream)this.outputStream);
    }

    private void removeFileRemote(String file) {
        SshUtils.removeFile((String)this.publicacaoForm.getServidor(), (int)this.publicacaoForm.getPorta(), (String)this.loginSshRemote, (String)this.senhaSshRemote, (String)file, (OutputStream)this.outputStream);
    }

    private void apagaWarUndeployed() {
        if (this.existsFileRemote(this.publicacaoForm.getDeploymentWarUndeployed())) {
            this.sshRemote("sudo rm " + this.publicacaoForm.getDeploymentWarUndeployed());
        }
    }

    private void apagaAplicacaoServidor() {
        this.sshRemote("sudo rm -rf " + this.getPastaSistemaTempServer());
    }

    private void copiaAplicacaoServidor() {
        String tempFolderPathLocal = this.getPastaSistemaBranchTempLocal() + File.separator;
        String copyFrom = tempFolderPathLocal + this.publicacaoForm.getArtefato() + "/target/" + this.publicacaoForm.getNomeWar();
        if (!new File(copyFrom).exists()) {
            throw new RuntimeException("Erro na compila\u00e7\u00e3o do artefato " + this.publicacaoForm.getNomeWar());
        }
        String copyTo = this.getPastaSistemaBranchTempServer() + File.separator;
        this.sshRemote("mkdir -p " + copyTo);
        SshUtils.scp((String)this.publicacaoForm.getServidor(), (int)this.publicacaoForm.getPorta(), (String)this.loginSshRemote, (String)this.senhaSshRemote, (String)copyFrom, (String)copyTo, (OutputStream)this.outputStream);
    }

    private void executaScriptAntesCompilacao() {
        ArrayList<String> commands = new ArrayList<String>();
        commands.add("source ~/.nvm/nvm.sh");
        if (this.publicacaoForm.isComandoAntesCompilacao()) {
            commands.add("cd " + this.getPastaSistemaBranchTempLocal());
            commands.addAll(Arrays.stream(this.publicacaoForm.getComandoAntesCompilacao().split(";")).toList());
        }
        this.sshLocal(commands);
    }

    private void compilaAplicacao(LocalType local, AmbienteType ambiente, String versao) {
        ArrayList<String> commands = new ArrayList<String>();
        commands.add("cd " + this.getPastaSistemaBranchTempLocal());
        String sed = (OperationSystemUtils.isMac() ? "g" : "") + "sed";
        for (String artefato : this.getArtefatos(local, ambiente)) {
            if (!StringUtils.isNullOrEmpty((String)this.nomeAlternativo)) {
                String sistema = artefato.replace("-web", "").replace("-job", "").replace("-ws", "");
                commands.add(sed + " -ri '/finalName/ s/" + sistema + "/" + this.nomeAlternativo + "/g' " + this.getPastaSistemaBranchTempLocal() + "/" + artefato + "/pom.xml");
                commands.add(sed + " -ri '/display-name/ s/" + sistema + "/" + this.nomeAlternativo + "/g' " + this.getPastaSistemaBranchTempLocal() + "/" + artefato + "/src/main/webapp/WEB-INF/web.xml");
                commands.add(sed + " -ri '/context-root/ s/" + sistema + "/" + this.nomeAlternativo + "/g' " + this.getPastaSistemaBranchTempLocal() + "/" + artefato + "/src/main/webapp/WEB-INF/jboss-web.xml");
            }
            if (this.mostraComandoSql) {
                commands.add(sed + " -ri '/show_sql/ s/false/true/g' " + this.getPastaSistemaBranchTempLocal() + "/" + artefato + "/src/main/resources/META-INF/persistence.xml");
                continue;
            }
            commands.add(sed + " -ri '/show_sql/ s/true/false/g' " + this.getPastaSistemaBranchTempLocal() + "/" + artefato + "/src/main/resources/META-INF/persistence.xml");
        }
        if (OperationSystemUtils.isLinux()) {
            commands.add("export JAVA_HOME=/usr/lib/jvm/jdk-" + this.versaoJava.getAbbreviation());
        } else if (OperationSystemUtils.isMac()) {
            commands.add("export JAVA_HOME=/Library/Java/JavaVirtualMachines/jdk-" + this.versaoJava.getAbbreviation() + ".jdk/Contents/Home");
        }
        commands.add("cd " + this.getPastaSistemaBranchTempLocal());
        Object mvn = "mvn -U -DskipTests -Dmaven.wagon.http.ssl.insecure=true -Dmaven.wagon.http.ssl.allowall=true -Dmaven.wagon.http.ssl.ignore.validity.dates=true";
        mvn = (String)mvn + " -Dversion.external='" + versao + "'";
        if (!this.trunk && !StringUtils.isNullOrEmpty((String)this.branchPacote)) {
            mvn = (String)mvn + "." + this.branchPacote.replace("DSF-", "");
        }
        mvn = (String)mvn + " clean package";
        commands.add((String)mvn);
        this.sshLocal(commands);
    }

    private String getPastaSistemaTempLocal() {
        return String.valueOf(FileUtils.pathTemp()) + File.separator + this.loginSvn + File.separator + this.projetoSvn;
    }

    private String getPastaSistemaBranchTempLocal() {
        return this.getPastaSistemaTempLocal() + File.separator + (StringUtils.isNullOrEmpty((String)this.branchPacote) ? "trunk" : this.branchPacote);
    }

    private String getPastaSistemaTempServer() {
        return String.valueOf(FileUtils.pathTemp()) + File.separator + this.loginSvn + File.separator + this.projetoSvn + File.separator + (StringUtils.isNullOrEmpty((String)this.branchPacote) ? "trunk" : this.branchPacote);
    }

    private Set<String> getArtefatos(LocalType local, AmbienteType ambiente) {
        return this.publicacoesSistema.stream().filter(p -> p.getLocal().equals((Object)local)).filter(p -> p.getAmbiente().equals((Object)ambiente)).map(PublicacaoForm::getArtefato).collect(Collectors.toSet());
    }

    private String getPastaSistemaBranchTempServer() {
        return this.getPastaSistemaBranchTempLocal().replace(FileUtils.pathTemp().getAbsolutePath(), "/tmp");
    }

    private static void lancaExcecaoErroDurantePublicacao(String messagemErro) {
        throw new RuntimeException(messagemErro);
    }

    private void baixaFontesSvn() {
        if (this.isPublicadoParcialmente()) {
            return;
        }
        try {
            URL urlTrunk = PastaUtil.getUrlTrunk(this.servidorSvn, this.projetoSvn);
            URL urlBranch = PastaUtil.getUrlBranch(this.servidorSvn, this.projetoSvn, this.branchPacote);
            URL urlBranchBaixar = this.trunk ? urlTrunk : urlBranch;
            this.apagaFontes();
            File pastaBranchLocal = new File(this.getPastaSistemaBranchTempLocal());
            this.sshLocal("mkdir -p " + pastaBranchLocal.getAbsolutePath());
            String userWagnerSvn = "wagner.araujo";
            String passwordWagnerSvn = "j2s5s_cr3st4@";
            List<CallSite> commands = List.of("cd " + this.getPastaSistemaTempLocal(), "svn checkout --username " + userWagnerSvn + " --password " + passwordWagnerSvn + " " + String.valueOf(urlBranchBaixar) + ".");
            this.sshLocal(commands);
            if (!this.trunk) {
                commands = List.of("cd " + this.getPastaSistemaBranchTempLocal(), "svn merge --username " + userWagnerSvn + " --password " + passwordWagnerSvn + " " + String.valueOf(urlTrunk) + ".");
                this.sshLocal(commands);
            }
            SvnFachada svnFachada = new SvnFachada(userWagnerSvn, passwordWagnerSvn, this.outputStream);
            svnFachada.verificaConflito(pastaBranchLocal);
        }
        catch (Exception ex) {
            this.log(ex.getMessage());
            LogUtils.generate((Throwable)ex);
            throw new RuntimeException(ex);
        }
    }

    public List<LocalType> getLocais() {
        return this.getPublicacoesSistema().stream().map(PublicacaoForm::getLocal).distinct().sorted().toList();
    }

    public List<AmbienteType> getAmbientes() {
        return this.getPublicacoesSistema().stream().map(PublicacaoForm::getAmbiente).distinct().sorted().toList();
    }

    public List<ModuloType> getModulos() {
        return this.getPublicacoesSistema().stream().sorted(Comparator.comparing(PublicacaoForm::getComandoAntesCompilacao).reversed().thenComparing(PublicacaoForm::getModulo)).map(PublicacaoForm::getModulo).distinct().sorted().toList();
    }

    public String getLogCopiaColaJira() {
        List logPublicacaoOk = Arrays.stream(this.getLogMessages().toString().split("\n")).collect(Collectors.toList());
        logPublicacaoOk.removeIf(l -> !l.startsWith("###") && !l.startsWith("- "));
        return String.valueOf(this.getLogMessages()) + "\n\n >>>>> COPIE O LOG ABAIXO E COLE NA TASK DO JIRA <<<<<\n\n" + String.join((CharSequence)"\n", logPublicacaoOk);
    }

    private void log(String message) {
        try {
            String log = Utils.ajustaLog(message);
            this.outputStream.write(log.concat("\n").getBytes());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        LogUtils.generate((String)message);
    }

    private void sshLocal(String command) {
        this.sshLocal(List.of(command));
    }

    private void sshLocal(List<String> commandosOriginal) {
        ArrayList<String> commands = new ArrayList<String>();
        if (OperationSystemUtils.isMac()) {
            commands.add("source ~/.bash_profile");
        } else {
            commands.add("source ~/.bashrc");
        }
        if (this.viaServidorAplicacao) {
            // empty if block
        }
        commands.addAll(commandosOriginal);
        SshUtils.executeCommand((String)"localhost", (int)22, (String)this.loginSshLocal, (String)this.senhaSshLocal, commands, (OutputStream)this.outputStream);
    }

    private void sshRemote(String command) {
        this.sshRemote(List.of(command));
    }

    private void sshRemote(List<String> commands) {
        SshUtils.executeCommand((String)this.publicacaoForm.getServidor(), (int)this.publicacaoForm.getPorta(), (String)this.loginSshRemote, (String)this.senhaSshRemote, commands, (OutputStream)this.outputStream);
    }

    public StringBuilder getLogMessages() {
        return new StringBuilder(this.outputStream.toString());
    }
}

